/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.inject.proxy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.test4j.mock.Stubs;
import org.test4j.module.inject.Inject;
import org.test4j.module.inject.Injected;
import org.test4j.module.inject.proxy.FieldProxy;

public class InjectHelper {
    public static void injectIntoTestedObject(Object testedObject) {
        Set<Field> injects = InjectHelper.getAnnotationFields(testedObject.getClass(), Inject.class);
        for (Field field : injects) {
            Object value = InjectHelper.getProxyValue(testedObject, field);
            Inject inject = field.getAnnotation(Inject.class);
            List<Object> targets = InjectHelper.targetField(testedObject, inject);
            String[] properties = InjectHelper.properties(field, inject);
            for (Object target : targets) {
                InjectHelper.injectFieldIntoTarget(target, value, properties);
            }
            if (!inject.stub()) continue;
            try {
                field.setAccessible(true);
                field.set(testedObject, Stubs.fake(field.getType()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Object getProxyValue(Object testedObject, Field field) {
        try {
            return FieldProxy.proxy(testedObject.getClass(), field);
        }
        catch (Exception e) {
            return InjectHelper.getFieldValue(testedObject, field);
        }
    }

    private static void injectFieldIntoTarget(Object target, Object fieldValue, String[] properties) {
        for (String property : properties) {
            try {
                Field field = InjectHelper.getField(target.getClass(), property);
                field.setAccessible(true);
                field.set(target, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("injectFieldIntoTarget, field name:" + property, e);
            }
        }
    }

    private static List<Object> targetField(Object testedObject, Inject inject) {
        ArrayList<Object> injected = new ArrayList<Object>();
        if (inject.targets().length == 0) {
            Set<Field> fields = InjectHelper.getAnnotationFields(testedObject.getClass(), Injected.class);
            for (Field field : fields) {
                field.setAccessible(true);
                injected.add(InjectHelper.getFieldValue(testedObject, field));
            }
        } else {
            for (String target : inject.targets()) {
                injected.add(InjectHelper.getFieldValue(testedObject, target));
            }
        }
        return injected;
    }

    private static Object getFieldValue(Object testedObject, Field field) {
        try {
            field.setAccessible(true);
            return field.get(testedObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("getFieldObject[" + field.getName() + "] error:" + e.getMessage(), e);
        }
    }

    private static Object getFieldValue(Object testedObject, String name) {
        Field field = InjectHelper.getField(testedObject.getClass(), name);
        return InjectHelper.getFieldValue(testedObject, field);
    }

    public static Field getField(Class cls, String name) {
        while (cls != Object.class) {
            try {
                return cls.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                cls = cls.getSuperclass();
            }
        }
        throw new RuntimeException("No such field: " + name);
    }

    private static String[] properties(Field field, Inject inject) {
        if (inject.properties().length == 0) {
            return new String[]{field.getName()};
        }
        return inject.properties();
    }

    private static Set<Field> getAnnotationFields(Class clazz, Class annotation) {
        Field[] fields;
        if (Object.class.equals((Object)clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Object o = field.getAnnotation(annotation);
            if (o == null) continue;
            annotatedFields.add(field);
        }
        annotatedFields.addAll(InjectHelper.getAnnotationFields(clazz.getSuperclass(), annotation));
        return annotatedFields;
    }
}

