/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.stub;

import g_cglib.net.sf.cglib.proxy.MethodInterceptor;
import g_cglib.net.sf.cglib.proxy.MethodProxy;
import java.lang.reflect.Method;
import org.test4j.mock.Invocation;
import org.test4j.mock.faking.FakeInvoker;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.meta.FakeStates;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.meta.TimesVerify;
import org.test4j.mock.stub.StubFakeInvocation;

public class FakeInterceptor
implements MethodInterceptor {
    private final Class aClass;

    public FakeInterceptor(Class aClass) {
        this.aClass = aClass;
    }

    public Object intercept(final Object target, Method method, final Object[] args, MethodProxy methodProxy) {
        MethodId methodId = new MethodId(this.aClass, method);
        final FakeMethod fakeMethod = FakeStates.getLastMethod(methodId);
        if (fakeMethod == null) {
            throw new AssertionError((Object)String.format("Method(%s#%s) not implemented or not mocked.", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        if (fakeMethod.isProceeding()) {
            throw new RuntimeException(String.format("the abstract method(%s#%s) can't be reentry again.", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        FakeInvoker invoker = new FakeInvoker(target, fakeMethod, this.aClass, method, args){

            @Override
            protected Invocation newInvocation() {
                return new StubFakeInvocation(target, args, fakeMethod.getTimesInvoked());
            }
        };
        TimesVerify.increaseTimes(methodId);
        return invoker.callFakeMethod();
    }
}

