/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.startup;

import java.io.File;
import java.util.regex.Pattern;

public class JavaAgentHits {
    private static final Pattern JAR_REGEX = Pattern.compile(".*fluent-mock[-._\\d]*(-SNAPSHOT)?.jar");
    private static final String Dep_Jar_Path = "fluent-mock.jar";
    private static String hits = null;

    private JavaAgentHits() {
    }

    public static String message() {
        if (hits != null) {
            return hits;
        }
        String jarPath = JavaAgentHits.getJarPath();
        hits = "If fluent mock isn't initialized. Please check that your JVM is started with command option:\n\n==IDE JVM=====================\n\t-javaagent:" + jarPath + "\n\n==Maven maven-surefire-plugin=\n\t<configuration>\n\t\t<argLine>@{argLine} -javaagent:${settings.localRepository}/org/test4j/fluent-mock/${version}/fluent-mock-${version}.jar</argLine>\n\t</configuration>\n\n==gradle dependencies=========\n\tdependencies {\n\t\ttest {\n\t\t\tjvmArgs \"-javaagent:${classpath.find { it.name.contains(\"fluent-mock\") }.absolutePath}\"\n\t\t\tuseJUnitPlatform()\n\t\t}\n\t}\n================================";
        System.err.println(hits);
        return hits;
    }

    private static String getJarPath() {
        String[] classPath;
        String javaClazzPaths = System.getProperty("java.class.path");
        if (javaClazzPaths == null) {
            return Dep_Jar_Path;
        }
        for (String cpEntry : classPath = javaClazzPaths.split(File.pathSeparator)) {
            if (!JAR_REGEX.matcher(cpEntry).matches()) continue;
            return cpEntry;
        }
        return Dep_Jar_Path;
    }
}

