/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer.file;

import com.squareup.javapoet.ClassName;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.test4j.mock.faking.modifier.FakeTransformer;
import org.test4j.mock.faking.util.TypeUtility;
import org.test4j.mock.processor.filer.attr.ExecutableHelper;
import org.test4j.mock.processor.filer.file.MockUpFiler;

public class MockTypeFiler
extends MockUpFiler {
    private final TypeElement typeElement;

    public MockTypeFiler(TypeElement typeElement) {
        super(ClassName.get((TypeElement)typeElement));
        this.typeElement = typeElement;
        this.superClass = this.parserSuperClass();
        this.parseMethodIds();
        this.parseAbstractMethodIds();
    }

    private void parseAbstractMethodIds() {
        LinkedList queue = new LinkedList();
        this.typeElement.getInterfaces().forEach(queue::offer);
        while (!queue.isEmpty()) {
            Element element;
            TypeMirror type = (TypeMirror)queue.poll();
            if (!(type instanceof DeclaredType) || !((element = ((DeclaredType)type).asElement()) instanceof TypeElement)) continue;
            this.parseTypeMethod((TypeElement)element);
            ((TypeElement)element).getInterfaces().forEach(queue::offer);
        }
    }

    @Override
    protected ClassName parserSuperClass() {
        TypeMirror superTypeMirror = this.typeElement.getSuperclass();
        if (!(superTypeMirror instanceof DeclaredType)) {
            return null;
        }
        Element element = ((DeclaredType)superTypeMirror).asElement();
        if (!(element instanceof TypeElement) || FakeTransformer.notMockType(element.toString())) {
            return null;
        }
        TypeElement superType = (TypeElement)element;
        for (Modifier modifier : superType.getModifiers()) {
            if (modifier != Modifier.PRIVATE) continue;
            return null;
        }
        return ClassName.get((TypeElement)superType);
    }

    @Override
    protected void parseMethodIds() {
        this.parseTypeMethod(this.typeElement);
    }

    private void parseTypeMethod(TypeElement type) {
        List<? extends Element> elements = type.getEnclosedElements();
        Map<String, String> classVars = ExecutableHelper.getVarDesc(type.getTypeParameters(), new HashMap<String, String>());
        for (Element element : elements) {
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement executable = (ExecutableElement)element;
            String name = executable.getSimpleName().toString();
            int access = ExecutableHelper.getAccess(executable);
            if ("<clinit>".equals(name) || TypeUtility.isSynthetic(access)) continue;
            String paraDesc = ExecutableHelper.getParaDesc(executable, classVars);
            this.addMethodId(access, name, paraDesc);
        }
    }
}

