/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer.attr;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.HashMap;
import java.util.Map;

public class ClassNames {
    public static final String MockUp_Suffix = "FMockUp";
    public static final String Mock_Package_Prefix = "mock.";
    private static final Map<String, ClassName> primitiveBoxed = new HashMap<String, ClassName>(16);
    private static final Map<String, TypeName> primitiveArray = new HashMap<String, TypeName>(16);

    private ClassNames() {
    }

    public static ClassName getClassName(String fullName) {
        if (primitiveBoxed.containsKey(fullName)) {
            return primitiveBoxed.get(fullName);
        }
        int index = fullName.lastIndexOf(46);
        String packName = index < 0 ? "" : fullName.substring(0, index);
        String className = index < 0 ? fullName : fullName.substring(index + 1);
        return ClassName.get((String)packName, (String)className, (String[])new String[0]);
    }

    public static TypeName getReturnType(String fullName) {
        if (primitiveArray.containsKey(fullName)) {
            return primitiveArray.get(fullName);
        }
        if (fullName.endsWith("[]")) {
            TypeName typeName = ClassNames.getReturnType(fullName.substring(0, fullName.length() - 2));
            return ArrayTypeName.of((TypeName)typeName);
        }
        return ClassNames.getClassName(fullName);
    }

    public static ClassName mockup(ClassName className) {
        String packName = className.packageName();
        String klasName = String.join((CharSequence)"$", className.simpleNames()) + MockUp_Suffix;
        if (packName.startsWith("java.") || packName.startsWith("sun.") || packName.startsWith("javax.")) {
            return ClassName.get((String)(Mock_Package_Prefix + packName), (String)klasName, (String[])new String[0]);
        }
        return ClassName.get((String)packName, (String)klasName, (String[])new String[0]);
    }

    static {
        primitiveBoxed.put("void", ClassName.get(Void.class));
        primitiveBoxed.put("boolean", ClassName.get(Boolean.class));
        primitiveBoxed.put("char", ClassName.get(Character.class));
        primitiveBoxed.put("byte", ClassName.get(Byte.class));
        primitiveBoxed.put("short", ClassName.get(Short.class));
        primitiveBoxed.put("int", ClassName.get(Integer.class));
        primitiveBoxed.put("float", ClassName.get(Float.class));
        primitiveBoxed.put("long", ClassName.get(Long.class));
        primitiveBoxed.put("double", ClassName.get(Double.class));
        primitiveArray.put("boolean[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.BOOLEAN));
        primitiveArray.put("char[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.CHAR));
        primitiveArray.put("byte[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.BYTE));
        primitiveArray.put("short[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.SHORT));
        primitiveArray.put("int[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.INT));
        primitiveArray.put("float[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.FLOAT));
        primitiveArray.put("long[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.LONG));
        primitiveArray.put("double[]", (TypeName)ArrayTypeName.of((TypeName)ClassName.DOUBLE));
    }
}

