/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer.attr;

import com.squareup.javapoet.ClassName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class BeanAttribute {
    private final Class aClass;
    private final TypeElement element;

    public BeanAttribute(Class aClass, TypeElement element) {
        this.aClass = aClass;
        this.element = element;
    }

    public Set<ClassName> getClasses(String attribute) {
        AnnotationMirror mirror = this.getMocksMirror(this.element);
        HashSet<ClassName> values = new HashSet<ClassName>();
        if (mirror == null) {
            return values;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!method.toString().contains(attribute)) continue;
            List list = (List)value.getValue();
            for (AnnotationValue item : list) {
                ClassName className = (ClassName)ClassName.get((TypeMirror)((TypeMirror)item.getValue()));
                values.add(className);
            }
            return values;
        }
        return values;
    }

    public Map<String, ClassName> getNames(String attribute, String keyName, String valueName) {
        AnnotationMirror mirror = this.getMocksMirror(this.element);
        HashMap<String, ClassName> values = new HashMap<String, ClassName>();
        if (mirror == null) {
            return values;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!method.toString().contains(attribute)) continue;
            List list = (List)value.getValue();
            for (AnnotationMirror item : list) {
                String name = null;
                ClassName klass = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attr : item.getElementValues().entrySet()) {
                    String attrName = attr.getKey().toString();
                    if ((keyName + "()").equals(attrName)) {
                        name = attr.getValue().toString();
                        continue;
                    }
                    if (!(valueName + "()").equals(attrName)) continue;
                    klass = (ClassName)ClassName.get((TypeMirror)((TypeMirror)attr.getValue().getValue()));
                }
                if (name == null || name.trim().isEmpty() || klass == null) continue;
                values.put(name, klass);
            }
            return values;
        }
        return values;
    }

    private AnnotationMirror getMocksMirror(TypeElement element) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().toString().contains(this.aClass.getSimpleName())) continue;
            return annotationMirror;
        }
        return null;
    }
}

