/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.processor.filer;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.test4j.mock.faking.fluent.MocksApply;
import org.test4j.mock.processor.MocksProcessor;
import org.test4j.mock.processor.filer.attr.ClassNames;
import org.test4j.mock.processor.filer.file.MockClassFiler;
import org.test4j.mock.processor.filer.file.MockTypeFiler;
import org.test4j.mock.processor.filer.file.MockUpFiler;

public class MocksFiler {
    private static final Set<String> Has_Mocks = new ConcurrentSkipListSet<String>();
    private final ClassName fullName;
    private final String mocksClass;
    private final Map<String, ClassName> mocks = new HashMap<String, ClassName>();
    private final Map<String, Integer> counts = new HashMap<String, Integer>();
    private static final String Mock1_JavaDoc = " mock {@link $T} \u591a\u4e2a\u65b9\u6cd5, \u793a\u4f8b\u4ee3\u7801\n <pre>\n mocks.$L(fake->{\n      fake.toMockMethod1.restReturn(\"\u8fd4\u56de\u503c1\",\"\u8fd4\u56de\u503c2\");\n      fake.toMockMethod2.restReturn(\"\u8fd4\u56de\u503c1\",\"\u8fd4\u56de\u503c2\");\n });\n </pre>\n\n @param faker   {@link $LMockUp} \u6784\u9020\n @param targets \u6307\u5b9a, \u8868\u793a\u5bf9\u7279\u5b9a$L\u5b9e\u4f8b\u8fdb\u884cmock;\u5426\u5219,\u8868\u793a\u5bf9\u6240\u6709$L\u5b9e\u4f8b\u8fdb\u884cmock";
    private static final String Mock2_JavaDoc = " mock {@link $T} \u5355\u4e2a\u65b9\u6cd5, \u793a\u4f8b\u4ee3\u7801\n <pre>\n mocks.$L().toMockMethod1.restReturn(\"\u8fd4\u56de\u503c1\",\"\u8fd4\u56de\u503c2\");\n </pre>\n\n @param targets \u6307\u5b9a, \u8868\u793a\u5bf9\u7279\u5b9a$L\u5b9e\u4f8b\u8fdb\u884cmock;\u5426\u5219,\u8868\u793a\u5bf9\u6240\u6709$L\u5b9e\u4f8b\u8fdb\u884cmock";

    public MocksFiler(String fullName, String suffix, Set<ClassName> classNames) {
        this.fullName = ClassNames.getClassName(fullName);
        this.mocksClass = this.fullName.simpleName() + suffix;
        this.addToMockClass(classNames);
    }

    private void addToMockClass(Collection<ClassName> classNames) {
        for (ClassName className : classNames) {
            this.addMockFile(className);
        }
    }

    private void addMockFile(ClassName className) {
        if (className == null) {
            return;
        }
        ClassName mockClassName = ClassNames.mockup(className);
        this.mocks.put(className.toString(), mockClassName);
    }

    public void writeFiler() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.mocksClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(MocksApply.class);
        this.build(builder);
        JavaFile.Builder javaBuilder = JavaFile.builder((String)this.fullName.packageName(), (TypeSpec)builder.build());
        MocksProcessor.writeFiler(javaBuilder.build());
    }

    private int count(ClassName toFaked) {
        String name = toFaked.simpleName();
        Integer count = this.counts.get(name);
        count = count == null ? 0 : count + 1;
        this.counts.put(name, count);
        return count;
    }

    private void build(TypeSpec.Builder spec) {
        spec.addField(this.f_mocks(this.mocksClass)).addMethod(this.m_mocks(this.mocksClass));
        for (Map.Entry<String, ClassName> entry : this.mocks.entrySet()) {
            ClassName toFaked = ClassNames.getClassName(entry.getKey());
            int count = this.count(toFaked);
            if (count > 0) {
                toFaked = ClassNames.getClassName(entry.getKey() + "__" + count);
            }
            spec.addMethod(this.m_mockUp1(toFaked, entry.getValue()));
            spec.addMethod(this.m_mockUp2(toFaked, entry.getValue()));
            spec.addField(this.f_mockUpField(toFaked, entry.getValue()));
        }
        while (!this.mocks.isEmpty()) {
            Map.Entry<String, ClassName> entry;
            Iterator<Map.Entry<String, ClassName>> it = this.mocks.entrySet().iterator();
            entry = it.next();
            it.remove();
            MockUpFiler mockUpFiler = this.generateMockUp(entry.getKey());
            if (mockUpFiler == null) continue;
            mockUpFiler.writeFiler();
            this.addMockFile(mockUpFiler.getSuperClass());
        }
    }

    private MethodSpec m_mockUp1(ClassName toFaked, ClassName mockUp) {
        String name = toFaked.simpleName();
        return MethodSpec.methodBuilder((String)toFaked.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc(Mock1_JavaDoc, new Object[]{toFaked, name, name, name, name}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{mockUp}), "faker", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of(Object.class), "targets", new Modifier[0]).varargs(true).returns((TypeName)TypeVariableName.get((String)this.mocksClass)).addStatement("return super.apply(faker, new $T(targets))", new Object[]{mockUp}).build();
    }

    private MethodSpec m_mockUp2(ClassName toFaked, ClassName mockUp) {
        String name = toFaked.simpleName();
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc(Mock2_JavaDoc, new Object[]{toFaked, name, name, name}).addParameter((TypeName)ArrayTypeName.of(Object.class), "targets", new Modifier[0]).varargs(true).returns((TypeName)mockUp).addStatement("return new $T(targets)", new Object[]{mockUp}).build();
    }

    private FieldSpec f_mockUpField(ClassName toFaked, ClassName mockUp) {
        String name = toFaked.simpleName();
        return FieldSpec.builder((TypeName)mockUp, (String)name, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addJavadoc("@see #$L(Object...), \u65e0\u53c2\u6a21\u5f0f ", new Object[]{name}).initializer("$L()", new Object[]{name}).build();
    }

    private FieldSpec f_mocks(String mocksClass) {
        return FieldSpec.builder((TypeName)ClassNames.getClassName(mocksClass), (String)"mocks", (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("\u5168\u5c40\u53d8\u91cf, \u65b9\u4fbf\u5728\u6d4b\u8bd5\u65b9\u6cd5\u4e2d\u5f15\u7528$L\u5b9e\u4f8b\n\u6bcf\u4e2a\u6d4b\u8bd5\u6267\u884c\u5b8c\u6bd5, \u672c\u5b9e\u4f8b\u4e2d\u5b9a\u4e49\u7684mock\u884c\u4e3a\u4f1a\u88ab\u6e05\u9664\n\u5982\u679c\u60f3\u5b9a\u4e49\u5168\u5c40mock\u884c\u4e3a, \u4f7f\u7528 mocks()\u65b9\u6cd5\u5f15\u7528", new Object[]{mocksClass}).initializer("mocks()", new Object[0]).build();
    }

    private MethodSpec m_mocks(String mocksClass) {
        return MethodSpec.methodBuilder((String)"mocks").returns((TypeName)ClassNames.getClassName(mocksClass)).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("$L\u5168\u5c40\u53d8\u91cf, \u65b9\u4fbf\u5f15\u7528", new Object[]{mocksClass}).addJavadoc("\u6bcf\u4e2a\u6d4b\u8bd5\u6267\u884c\u5b8c\u6bd5, mock\u884c\u4e3a\u4f1a\u88ab\u6e05\u9664", new Object[0]).addStatement("return new $L()", new Object[]{mocksClass}).build();
    }

    private MockUpFiler generateMockUp(String className) {
        if (Has_Mocks.contains(className)) {
            return null;
        }
        Has_Mocks.add(className);
        try {
            return new MockClassFiler(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            TypeElement typeElement = MocksProcessor.getTypeElement(className);
            if (typeElement != null) {
                return new MockTypeFiler(typeElement);
            }
            MocksProcessor.error("ClassNotFoundException", e);
            return null;
        }
    }
}

