/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.test4j.mock.MockUp;
import org.test4j.mock.faking.modifier.FakeTransformer;
import org.test4j.mock.faking.util.AsmType;

public final class TypeUtility {
    public static final Class[] NO_PARAMETERS = new Class[0];
    public static final Map<Class, Class> PRIMITIVE_TO_WRAPPER = new HashMap<Class, Class>();
    public static final Map<Class, Class> WRAPPER_TO_PRIMITIVE = new HashMap<Class, Class>();
    public static final Map<String, String> PRIMITIVE_DESC_ABBR = new HashMap<String, String>();
    public static final Map<String, Class> PRIMITIVE_CLASS = new HashMap<String, Class>();
    public static final Map<String, String> ABBR_TYPE_DESC = new HashMap<String, String>();

    private TypeUtility() {
    }

    public static String classPath(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String className = clazz.getName();
        int p = className.indexOf(47);
        if (p > 0) {
            className = className.substring(0, p);
        }
        return TypeUtility.classPath(className);
    }

    public static String classPath(String clazz) {
        return clazz.replace('.', '/');
    }

    public static Class getClassType(Type declaredType) {
        while (true) {
            Class rawType;
            if ((rawType = TypeUtility.getRawType(declaredType)) != null) {
                return rawType;
            }
            if (declaredType instanceof GenericArrayType) {
                declaredType = ((GenericArrayType)declaredType).getGenericComponentType();
                continue;
            }
            if (declaredType instanceof TypeVariable) {
                declaredType = ((TypeVariable)declaredType).getBounds()[0];
                continue;
            }
            if (!(declaredType instanceof WildcardType)) break;
            declaredType = ((WildcardType)declaredType).getUpperBounds()[0];
        }
        throw new IllegalArgumentException("Type of unexpected kind: " + declaredType);
    }

    public static Class getRawType(Type declaredType) {
        if (declaredType instanceof Class) {
            return (Class)declaredType;
        }
        if (declaredType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)declaredType).getRawType();
        }
        return null;
    }

    public static Class[] getParameterTypes(String methodDesc) {
        g_asm.org.objectweb.asm.Type[] paramTypes = g_asm.org.objectweb.asm.Type.getArgumentTypes((String)methodDesc);
        if (paramTypes.length == 0) {
            return NO_PARAMETERS;
        }
        Class[] paramClasses = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramClasses[i] = AsmType.getClassForType(paramTypes[i]);
        }
        return paramClasses;
    }

    public static Class getPrimitiveType(Class wrapperType) {
        return WRAPPER_TO_PRIMITIVE.get(wrapperType);
    }

    public static Type getTypeToFake(Class fakeClass) {
        while (true) {
            Type superclass;
            if ((superclass = fakeClass.getGenericSuperclass()) instanceof ParameterizedType) {
                Type[] types = ((ParameterizedType)superclass).getActualTypeArguments();
                return types[0];
            }
            if (superclass == MockUp.class) {
                throw new IllegalArgumentException("No target type");
            }
            fakeClass = (Class)superclass;
        }
    }

    public static String getTypeSignature(Type type) {
        Type[] typeArguments;
        StringBuilder signature = new StringBuilder(100);
        Class rawClazz = TypeUtility.getClassType(type);
        signature.append("L").append(TypeUtility.classPath(rawClazz));
        if (type instanceof ParameterizedType && (typeArguments = ((ParameterizedType)type).getActualTypeArguments()).length > 0) {
            signature.append('<');
            for (Type typeArg : typeArguments) {
                if (typeArg instanceof Class) {
                    Class classArg = (Class)typeArg;
                    signature.append('L').append(TypeUtility.classPath(classArg)).append(';');
                    continue;
                }
                signature.append('*');
            }
            signature.append('>');
        }
        return signature.append(';').toString();
    }

    public static String descriptor(String clazzName, Map<String, String> varMaps) {
        if (PRIMITIVE_DESC_ABBR.containsKey(clazzName)) {
            return PRIMITIVE_DESC_ABBR.get(clazzName);
        }
        if (varMaps != null && varMaps.containsKey(clazzName)) {
            return varMaps.get(clazzName);
        }
        StringBuilder buff = new StringBuilder();
        if (clazzName.endsWith("[]")) {
            buff.append("[");
            buff.append(TypeUtility.descriptor(clazzName.substring(0, clazzName.length() - 2), varMaps));
        } else {
            buff.append("L");
            int pos = clazzName.indexOf(60);
            if (pos > 0) {
                buff.append(TypeUtility.classPath(clazzName.substring(0, pos)));
            } else {
                buff.append(TypeUtility.classPath(clazzName));
            }
            buff.append(";");
        }
        return buff.toString();
    }

    public static boolean isConstructor(String name) {
        return "$init".equals(name) || "<init>".equals(name);
    }

    public static boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    public static Set<Class> findAllClass(Class clazz) {
        HashSet<Class> all = new HashSet<Class>();
        if (clazz == null) {
            return all;
        }
        LinkedList queue = new LinkedList();
        queue.offer(clazz);
        while (!queue.isEmpty()) {
            Class curr = (Class)queue.poll();
            if (curr == null || FakeTransformer.notMockType(curr.getName())) continue;
            all.add(curr);
            queue.offer(curr.getSuperclass());
            for (Class<?> _interface : curr.getInterfaces()) {
                queue.offer(_interface);
            }
        }
        return all;
    }

    public static Class getBoxingType(Class type) {
        return PRIMITIVE_TO_WRAPPER.getOrDefault(type, type);
    }

    public static List<Method> findInterfaceMethod(Class clazz) {
        return Stream.of(clazz.getMethods()).filter(m -> Modifier.isAbstract(m.getModifiers())).filter(m -> m.getDeclaringClass().isInterface()).collect(Collectors.toList());
    }

    public static boolean isAssignable(Class pType, Class cType) {
        Class pClass = TypeUtility.getBoxingType(pType);
        Class cClass = TypeUtility.getBoxingType(cType);
        if (pClass.equals(Object.class) || cClass.equals(Object.class)) {
            return true;
        }
        if (Objects.equals(pClass, cClass)) {
            return true;
        }
        return pClass.isAssignableFrom(cType);
    }

    public static String getShortClassName(String className) {
        if (className == null) {
            return "";
        }
        if (className.length() == 0) {
            return "";
        }
        StringBuilder arrayPrefix = new StringBuilder();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1);
            }
        }
        if (ABBR_TYPE_DESC.containsKey(className)) {
            className = ABBR_TYPE_DESC.get(className);
        }
        int lastDotIdx = className.lastIndexOf(46);
        String out = className.substring(lastDotIdx + 1);
        return out + arrayPrefix;
    }

    static {
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_DESC_ABBR.put("void", "V");
        PRIMITIVE_DESC_ABBR.put("boolean", "Z");
        PRIMITIVE_DESC_ABBR.put("char", "C");
        PRIMITIVE_DESC_ABBR.put("byte", "B");
        PRIMITIVE_DESC_ABBR.put("short", "S");
        PRIMITIVE_DESC_ABBR.put("int", "I");
        PRIMITIVE_DESC_ABBR.put("float", "F");
        PRIMITIVE_DESC_ABBR.put("long", "J");
        PRIMITIVE_DESC_ABBR.put("double", "D");
        ABBR_TYPE_DESC.put("V", "void");
        ABBR_TYPE_DESC.put("Z", "boolean");
        ABBR_TYPE_DESC.put("C", "char");
        ABBR_TYPE_DESC.put("B", "byte");
        ABBR_TYPE_DESC.put("S", "short");
        ABBR_TYPE_DESC.put("I", "int");
        ABBR_TYPE_DESC.put("F", "float");
        ABBR_TYPE_DESC.put("J", "long");
        ABBR_TYPE_DESC.put("D", "double");
        PRIMITIVE_CLASS.put("void", Void.TYPE);
        PRIMITIVE_CLASS.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASS.put("char", Character.TYPE);
        PRIMITIVE_CLASS.put("byte", Boolean.TYPE);
        PRIMITIVE_CLASS.put("short", Short.TYPE);
        PRIMITIVE_CLASS.put("int", Integer.TYPE);
        PRIMITIVE_CLASS.put("float", Float.TYPE);
        PRIMITIVE_CLASS.put("long", Long.TYPE);
        PRIMITIVE_CLASS.put("double", Double.TYPE);
    }
}

