/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.test4j.mock.faking.util.ReflectUtility;

public final class StackTrace {
    private final Throwable throwable;
    private static final List<String> Start_Filters = Arrays.asList("org.junit.", "org.testng.", "junit.framework", "org.test4j.integration.", "org.test4j.mock.faking.", "org.test4j.exception.Exceptions", "org.test4j.module.database.operator.", "org.test4j.module.spec.internal.");
    private static final List<String> Contain_Filters = Arrays.asList("$$EnhancerByCGLIB$$", ".reflect.", ".surefire.", ".gradle.", ".intellij.", ".eclipse.", ".jdt.");

    private StackTrace(Throwable throwable) {
        this.throwable = throwable;
    }

    public static void filterStackTrace(Throwable t) {
        if (t == null) {
            return;
        }
        try {
            new StackTrace(t).filter(new HashSet<Integer>());
        }
        catch (Exception e) {
            ReflectUtility.doThrow(t);
        }
    }

    void filter(Set<Integer> hasFilters) {
        int objId = System.identityHashCode(this.throwable);
        if (hasFilters.contains(objId) || this.throwable == null) {
            return;
        }
        hasFilters.add(objId);
        StackTraceElement[] elements = this.throwable.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elements.length];
        int index = 0;
        for (StackTraceElement ste : elements) {
            if (this.filter(ste)) continue;
            filtered[index] = ste;
            ++index;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[index];
        System.arraycopy(filtered, 0, newStackTrace, 0, index);
        this.throwable.setStackTrace(newStackTrace);
        new StackTrace(this.throwable.getCause()).filter(hasFilters);
    }

    private boolean filter(StackTraceElement ste) {
        if (ste.getFileName() == null) {
            return true;
        }
        String className = ste.getClassName();
        return StackTrace.isJDK(ste) || StackTrace.is3rdInternalMethod(className);
    }

    private static boolean isJDK(StackTraceElement ste) {
        String className = ste.getClassName();
        return className.startsWith("sun.") && !ste.isNativeMethod() || className.startsWith("jdk.") || className.startsWith("java.util.");
    }

    private static boolean is3rdInternalMethod(String className) {
        for (String pack : Start_Filters) {
            if (!className.startsWith(pack)) continue;
            return true;
        }
        for (String pack : Contain_Filters) {
            if (!className.contains(pack)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static String toString(Throwable e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

