/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.test4j.mock.Invocation;
import org.test4j.mock.faking.util.ClassFile;
import org.test4j.mock.faking.util.StackTrace;
import org.test4j.mock.faking.util.TypeUtility;
import org.test4j.mock.functions.ESupplier;

public class ReflectUtility {
    public static final Pattern JAVA_LANG = Pattern.compile("java.lang.", 16);
    private static Throwable exceptionToThrow;

    public ReflectUtility() throws Throwable {
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
    }

    public static synchronized <T> T doThrow(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        exceptionToThrow = e;
        try {
            ReflectUtility.class.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    public static Executable findMethodByDesc(Class theClass, String methodName, String memberDesc) {
        Class[] paramTypes = TypeUtility.getParameterTypes(memberDesc);
        Class superClass = theClass;
        if (TypeUtility.isConstructor(methodName)) {
            for (Constructor<?> declaredConstructor : superClass.getDeclaredConstructors()) {
                Class[] declaredParameterTypes = declaredConstructor.getParameterTypes();
                int firstRealParameter = ReflectUtility.indexOfFirstRealParameter(declaredParameterTypes, paramTypes);
                if (firstRealParameter == -1 || !ReflectUtility.acceptsArgumentTypes(declaredParameterTypes, paramTypes, firstRealParameter)) continue;
                return declaredConstructor;
            }
            throw new IllegalArgumentException("Specified constructor not found: " + ReflectUtility.toDescriptionMethod(theClass.getSimpleName(), paramTypes));
        }
        while (ClassFile.notObjectOrProxy(superClass)) {
            Method method = ReflectUtility.findMethodInClassOrInterface(superClass, methodName, paramTypes);
            if (method == null) {
                superClass = superClass.getSuperclass();
                continue;
            }
            return method;
        }
        throw new RuntimeException("NoSuchMethod:" + theClass.getName() + "#" + methodName + memberDesc);
    }

    private static Method findMethodInClassOrInterface(Class theClass, String methodName, Class[] paramTypes) {
        try {
            Method method = theClass.getDeclaredMethod(methodName, paramTypes);
            return method.isBridge() ? null : method;
        }
        catch (NoSuchMethodException e) {
            for (Class<?> anInterface : theClass.getInterfaces()) {
                try {
                    return anInterface.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            return null;
        }
    }

    public static String toDescriptionMethod(String method, Class[] paramTypes) {
        return method + Stream.of(paramTypes).map(Class::getCanonicalName).map(name -> JAVA_LANG.matcher((CharSequence)name).replaceAll("")).collect(Collectors.joining(", ", "(", ")"));
    }

    private static int indexOfFirstRealParameter(Class[] mockParameterTypes, Class[] realParameterTypes) {
        int extraParameters = mockParameterTypes.length - realParameterTypes.length;
        if (extraParameters == 1) {
            return mockParameterTypes[0] == Invocation.class ? 1 : -1;
        }
        return extraParameters != 0 ? -1 : 0;
    }

    private static boolean acceptsArgumentTypes(Class[] declaredTypes, Class[] specifiedTypes, int firstParameter) {
        for (int index = firstParameter; index < declaredTypes.length; ++index) {
            Class declaredType = declaredTypes[index];
            Class specifiedType = specifiedTypes[index - firstParameter];
            if (TypeUtility.isAssignable(declaredType, specifiedType)) continue;
            return false;
        }
        return true;
    }

    public static <T> T newInstance(Class aClass, String argument) {
        try {
            if (argument == null) {
                Constructor constructor = aClass.getDeclaredConstructor(new Class[0]);
                return ReflectUtility.invoke(constructor, () -> constructor.newInstance(new Object[0]));
            }
            Constructor constructor = aClass.getDeclaredConstructor(String.class);
            return ReflectUtility.invoke(constructor, () -> constructor.newInstance(argument));
        }
        catch (NoSuchMethodException e) {
            return ReflectUtility.doThrow(e);
        }
    }

    public static <T> T invoke(Object targetInstance, Method method, Object ... methodArgs) {
        return ReflectUtility.invoke(method, () -> method.invoke(targetInstance, methodArgs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invoke(Executable method, ESupplier supplier) {
        boolean accessible = method.isAccessible();
        try {
            Object obj;
            method.setAccessible(true);
            Object object = obj = supplier.get();
            return (T)object;
        }
        catch (IllegalArgumentException e) {
            StackTrace.filterStackTrace(e);
            throw new IllegalArgumentException("Failure to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            T t = ReflectUtility.doThrow(e.getCause());
            return t;
        }
        catch (Throwable e) {
            T t = ReflectUtility.doThrow(e);
            return t;
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    public static String getCorrespondingFakeName(String name) {
        if ("<init>".equals(name)) {
            return "$init";
        }
        if ("<clinit>".equals(name)) {
            return "$clinit";
        }
        return name;
    }
}

