/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import java.util.concurrent.locks.ReentrantLock;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.mock.faking.util.SearchingClassLoader;
import org.test4j.mock.faking.util.TypeUtility;

public final class ClassLoad {
    public static final ClassLoader CLASS_LOADER = SearchingClassLoader.combineLoadersOf(null, new Class[0]);
    private static final ReentrantLock LOCK = new ReentrantLock();

    private ClassLoad() {
    }

    public static ClassLoader loadersOf(Class first, Class ... types) {
        return SearchingClassLoader.combineLoadersOf(first, types);
    }

    public static <T> Class<T> loadClass(String className) {
        if (className == null) {
            return null;
        }
        if (TypeUtility.PRIMITIVE_CLASS.containsKey(className)) {
            return TypeUtility.PRIMITIVE_CLASS.get(className);
        }
        try {
            String clazzName = className.replace('/', '.');
            return Class.forName(clazzName, false, CLASS_LOADER);
        }
        catch (ClassNotFoundException | LinkageError e) {
            return (Class)ReflectUtility.doThrow(e);
        }
    }

    public static boolean isInClasspath(String typeName) {
        try {
            Class clazz = ClassLoad.loadClass(typeName);
            return clazz != null;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static boolean isLoading() {
        return LOCK.isHeldByCurrentThread();
    }
}

