/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import g_asm.org.objectweb.asm.ClassReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.mock.faking.util.TypeUtility;

public final class ClassFile {
    private static final Set<String> Print_Fakes = new HashSet<String>();

    private ClassFile() {
    }

    public static boolean notObjectOrProxy(Class aClass) {
        return aClass != null && !Objects.equals(aClass, Object.class) && !Objects.equals(aClass, Proxy.class);
    }

    private static byte[] readBytesFromClassFile(String classDesc) {
        return ClassFile.readBytes(classDesc);
    }

    public static byte[] readBytesFromClassFile(Class aClass) {
        String classDesc = TypeUtility.classPath(aClass);
        return ClassFile.readBytesFromClassFile(classDesc);
    }

    public static ClassReader getClassReader(Class clazz) {
        byte[] bytes = ClassFile.readBytes(TypeUtility.classPath(clazz));
        return new ClassReader(bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(String classDesc) {
        try (InputStream is = ClassFile.getClassInputStream(classDesc);){
            byte[] bytecode = new byte[is.available()];
            int len = 0;
            while (true) {
                int n;
                if ((n = is.read(bytecode, len, bytecode.length - len)) == -1) {
                    byte[] truncatedCopy;
                    if (len < bytecode.length) {
                        truncatedCopy = new byte[len];
                        System.arraycopy(bytecode, 0, truncatedCopy, 0, len);
                        bytecode = truncatedCopy;
                    }
                    truncatedCopy = bytecode;
                    return truncatedCopy;
                }
                if ((len += n) != bytecode.length) continue;
                int last = is.read();
                if (last < 0) {
                    byte[] byArray = bytecode;
                    return byArray;
                }
                byte[] lengthenedCopy = new byte[bytecode.length + 1000];
                System.arraycopy(bytecode, 0, lengthenedCopy, 0, len);
                lengthenedCopy[len++] = (byte)last;
                bytecode = lengthenedCopy;
                continue;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for " + classDesc.replace('/', '.'), e);
        }
    }

    private static InputStream getClassInputStream(String classDesc) {
        String classFileName = classDesc + ".class";
        InputStream inputStream = ClassLoad.CLASS_LOADER.getResourceAsStream(classFileName);
        if (inputStream != null) {
            return inputStream;
        }
        throw new NotFoundException(classDesc);
    }

    public static void initPrintFakes() {
        String[] items;
        String fakes = System.getProperty("PrintFake");
        if (fakes == null || fakes.trim().isEmpty()) {
            return;
        }
        for (String item : items = fakes.split("[,;]")) {
            if (item == null || item.trim().isEmpty()) continue;
            Print_Fakes.add(item.trim());
        }
    }

    public static void writeBytes4Debug(String fakeClass, byte[] bytes) {
        if (!ClassFile.needPrintFakeFile(fakeClass)) {
            return;
        }
        String fileName = System.getProperty("user.dir") + "/target/mock/" + fakeClass.replace('.', '/').replace('$', '.') + ".class";
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(file);
             ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            int len;
            byte[] buff = new byte[1024];
            while ((len = is.read(buff)) != -1) {
                ((OutputStream)out).write(buff, 0, len);
            }
        }
        catch (Exception e) {
            ReflectUtility.doThrow(e);
        }
    }

    private static boolean needPrintFakeFile(String fakeClass) {
        if (Print_Fakes.isEmpty()) {
            return false;
        }
        for (String namePart : Print_Fakes) {
            if (!fakeClass.contains(namePart)) continue;
            return true;
        }
        return false;
    }

    public static final class NotFoundException
    extends RuntimeException {
        private NotFoundException(String classNameOrDesc) {
            super("Unable to find class file for " + classNameOrDesc.replace('/', '.'));
        }
    }
}

