/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.util;

import g_asm.org.objectweb.asm.Type;
import java.util.HashMap;
import java.util.Map;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.TypeDesc;

public class AsmType {
    private static final Map<Integer, Class> PRIMITIVE_TYPES = new HashMap<Integer, Class>();
    public static final Map<Integer, TypeDesc> PRIMITIVE_OBJECTS = new HashMap<Integer, TypeDesc>();

    public static Class getClassForType(Type javaType) {
        if (AsmType.isPrimitive(javaType)) {
            return PRIMITIVE_TYPES.get(javaType.getSort());
        }
        String className = javaType.getClassName();
        if (javaType.getSort() == 9) {
            className = javaType.getDescriptor().replace("/", ".");
        }
        return ClassLoad.loadClass(className);
    }

    public static String getTypeDesc(Type javaType) {
        if (AsmType.isReferenceType(javaType)) {
            return javaType.getInternalName();
        }
        if (AsmType.isPrimitive(javaType)) {
            return AsmType.PRIMITIVE_OBJECTS.get((Object)Integer.valueOf((int)javaType.getSort())).PATH;
        }
        return javaType.getDescriptor();
    }

    public static boolean isPrimitive(Type type) {
        return type.getSort() <= 8;
    }

    public static boolean isReferenceType(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    static {
        PRIMITIVE_TYPES.put(0, Void.TYPE);
        PRIMITIVE_TYPES.put(1, Boolean.TYPE);
        PRIMITIVE_TYPES.put(2, Character.TYPE);
        PRIMITIVE_TYPES.put(3, Byte.TYPE);
        PRIMITIVE_TYPES.put(4, Short.TYPE);
        PRIMITIVE_TYPES.put(5, Integer.TYPE);
        PRIMITIVE_TYPES.put(6, Float.TYPE);
        PRIMITIVE_TYPES.put(7, Long.TYPE);
        PRIMITIVE_TYPES.put(8, Double.TYPE);
        PRIMITIVE_OBJECTS.put(0, TypeDesc.T_Void);
        PRIMITIVE_OBJECTS.put(1, TypeDesc.T_Boolean);
        PRIMITIVE_OBJECTS.put(2, TypeDesc.T_Character);
        PRIMITIVE_OBJECTS.put(3, TypeDesc.T_Byte);
        PRIMITIVE_OBJECTS.put(4, TypeDesc.T_Short);
        PRIMITIVE_OBJECTS.put(5, TypeDesc.T_Integer);
        PRIMITIVE_OBJECTS.put(6, TypeDesc.T_Float);
        PRIMITIVE_OBJECTS.put(7, TypeDesc.T_Long);
        PRIMITIVE_OBJECTS.put(8, TypeDesc.T_Double);
    }
}

