/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.modifier;

import g_asm.org.objectweb.asm.Label;
import g_asm.org.objectweb.asm.MethodVisitor;
import g_asm.org.objectweb.asm.Type;
import java.lang.reflect.Modifier;
import org.test4j.mock.faking.FakeInvoker;
import org.test4j.mock.faking.modifier.FakeClassModifier;
import org.test4j.mock.faking.util.AsmType;
import org.test4j.mock.faking.util.TypeDesc;
import org.test4j.mock.faking.util.TypeUtility;

public class FakeMethodModifier
extends MethodVisitor {
    private final FakeClassModifier cv;
    private final int access;
    private final String name;
    private final String desc;
    private final boolean isConstructor;
    private boolean alreadyCopied;
    static final String Invocation_Desc = String.format("(%s%s[%s)%s", TypeDesc.T_Object.DESC, TypeDesc.T_Method.DESC, TypeDesc.T_Object.DESC, TypeDesc.T_Object.DESC);

    FakeMethodModifier(FakeClassModifier cv, MethodVisitor mv, int access, String name, String desc) {
        super(458752, mv);
        this.cv = cv;
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.isConstructor = TypeUtility.isConstructor(name);
        if (!this.isConstructor) {
            this.callFakeMethod();
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        if (this.fakeConstructor(owner, opcode, name)) {
            this.callFakeConstructor();
            this.alreadyCopied = true;
        }
    }

    private boolean fakeConstructor(String owner, int opcode, String name) {
        if (!this.isConstructor || this.alreadyCopied) {
            return false;
        }
        if (!TypeUtility.isConstructor(name) || opcode != 183) {
            return false;
        }
        return owner.equals(this.cv.superClassName) || owner.equals(this.cv.classDesc);
    }

    public final void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (end.getOffset() > 0) {
            Label _start = start.getOffset() > end.getOffset() ? end : start;
            this.mv.visitLocalVariable(name, desc, signature, _start, end, index);
        }
    }

    public void callFakeMethod() {
        Type[] argTypes = Type.getArgumentTypes((String)this.desc);
        int index = this.argsObjectArray(argTypes);
        super.visitVarInsn(58, index + 1);
        this.byteCallFakeMethod(index + 1);
        super.visitVarInsn(58, index + 2);
        super.visitVarInsn(25, index + 2);
        this.visitLdcInsn("_Enter_Non_Mock_Block_");
        Label label = new Label();
        this.visitJumpInsn(165, label);
        this.byteReturnValue(index + 2);
        this.visitLabel(label);
    }

    public void callFakeConstructor() {
        super.visitFieldInsn(178, FakeInvoker.getHostClassName(), "$FakeInv", TypeDesc.T_InvocationHandler.DESC);
        this.push1stArgThis();
        this.push2ndArgMethod();
        Type[] argTypes = Type.getArgumentTypes((String)this.desc);
        this.argsObjectArray(argTypes);
        super.visitMethodInsn(185, TypeDesc.T_InvocationHandler.PATH, "invoke", Invocation_Desc, true);
        this.visitLdcInsn("_Enter_Non_Mock_Block_");
        Label label = new Label();
        this.visitJumpInsn(165, label);
        super.visitInsn(177);
        this.visitLabel(label);
    }

    private int argsObjectArray(Type[] argTypes) {
        super.visitIntInsn(16, 3 + argTypes.length);
        super.visitTypeInsn(189, TypeDesc.T_Object.PATH);
        this.visitStringOfArray(0, this.cv.classDesc);
        this.visitStringOfArray(1, this.name);
        this.visitStringOfArray(2, this.desc);
        int localVarIndex = Modifier.isStatic(this.access) ? 0 : 1;
        for (int index = 0; index < argTypes.length; ++index) {
            Type type = argTypes[index];
            this.visitTypeOfArray(3 + index, type, localVarIndex);
            localVarIndex += argTypes[index].getSize();
        }
        return localVarIndex - (Modifier.isStatic(this.access) ? 0 : 1);
    }

    private void byteCallFakeMethod(int localIndex) {
        super.visitFieldInsn(178, FakeInvoker.getHostClassName(), "$FakeInv", TypeDesc.T_InvocationHandler.DESC);
        this.push1stArgThis();
        this.push2ndArgMethod();
        super.visitVarInsn(25, localIndex);
        super.visitMethodInsn(185, TypeDesc.T_InvocationHandler.PATH, "invoke", Invocation_Desc, true);
    }

    private void byteReturnValue(int localIndex) {
        Type returnType = Type.getReturnType((String)this.desc);
        if (returnType.getSort() == 0) {
            super.visitInsn(returnType.getOpcode(172));
            return;
        }
        super.visitVarInsn(25, localIndex);
        this.visitTypeInsn(192, AsmType.getTypeDesc(returnType));
        if (AsmType.isPrimitive(returnType)) {
            String methodName = returnType.getClassName() + "Value";
            String typePath = AsmType.PRIMITIVE_OBJECTS.get((Object)Integer.valueOf((int)returnType.getSort())).PATH;
            String methodDesc = "()" + returnType.getInternalName();
            super.visitMethodInsn(182, typePath, methodName, methodDesc, false);
        }
        super.visitInsn(returnType.getOpcode(172));
    }

    private void visitTypeOfArray(int index, Type type, int localVarIndex) {
        super.visitInsn(89);
        super.visitIntInsn(17, index);
        super.visitVarInsn(type.getOpcode(21), localVarIndex);
        if (AsmType.isPrimitive(type)) {
            String typePath = AsmType.PRIMITIVE_OBJECTS.get((Object)Integer.valueOf((int)type.getSort())).PATH;
            String typeDesc = '(' + type.getDescriptor() + ")L" + typePath + ';';
            super.visitMethodInsn(184, typePath, "valueOf", typeDesc, false);
        }
        super.visitInsn(83);
    }

    private void visitStringOfArray(int index, String value) {
        super.visitInsn(89);
        super.visitIntInsn(17, index);
        super.visitLdcInsn((Object)value);
        super.visitInsn(83);
    }

    private void push2ndArgMethod() {
        super.visitInsn(1);
        super.visitTypeInsn(192, TypeDesc.T_Method.PATH);
    }

    private void push1stArgThis() {
        if (Modifier.isStatic(this.access)) {
            super.visitInsn(1);
        } else {
            super.visitVarInsn(25, 0);
        }
    }
}

