/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import g_asm.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.mock.faking.util.TypeDesc;
import org.test4j.mock.faking.util.TypeUtility;

public class MethodId {
    public final String realClassDesc;
    public int targetHashCode = 0;
    public final String declaredClassDesc;
    public final String name;
    public final String desc;
    public final boolean hasInvocation;
    public final String descNoInvocation;
    private boolean isMockMethod = false;
    public final String methodDesc;
    private Type[] params = null;
    private Type returnType = null;
    private Class realClass;
    private Map<Integer, ParaNameType> parameters;

    public MethodId(Class realClassDesc, Method method) {
        this(realClassDesc, method.getDeclaringClass(), method.getName(), Type.getMethodDescriptor((Method)method));
    }

    public MethodId(Class realClassDesc, Class declaredClassDesc, String name, String desc) {
        this(TypeUtility.classPath(realClassDesc), TypeUtility.classPath(declaredClassDesc), name, desc);
    }

    public MethodId(String realClassDesc, String declaredClassDesc, String name, String desc) {
        this.realClassDesc = realClassDesc;
        this.declaredClassDesc = declaredClassDesc;
        this.name = name;
        this.desc = desc;
        this.hasInvocation = this.desc.contains(TypeDesc.T_Invocation.DESC);
        this.descNoInvocation = this.hasInvocation ? '(' + this.desc.substring(TypeDesc.T_Invocation.DESC.length() + 1) : this.desc;
        this.methodDesc = MethodId.buildMethodDesc(this.name, this.descNoInvocation);
    }

    public static String buildMethodDesc(String name, String desc) {
        String _name = ReflectUtility.getCorrespondingFakeName(name);
        int end = desc.lastIndexOf(41) + 1;
        if (desc.contains(TypeDesc.T_Invocation.DESC)) {
            return _name + '(' + desc.substring(TypeDesc.T_Invocation.DESC.length() + 1, end);
        }
        return _name + desc.substring(0, end);
    }

    public static String getName(String methodDesc) {
        int index = methodDesc.indexOf("(");
        return methodDesc.substring(0, index);
    }

    public static String getDesc(String methodDesc) {
        int index = methodDesc.indexOf("(");
        return methodDesc.substring(index);
    }

    public Type[] getParams() {
        try {
            if (this.params == null) {
                this.params = Type.getArgumentTypes((String)this.desc);
            }
            return this.params;
        }
        catch (Throwable e) {
            throw new RuntimeException("getParams[" + this.desc + "] error:" + e.getMessage(), e);
        }
    }

    public String[] getParaTypeNames() {
        return (String[])Stream.of(this.getParams()).map(Type::getClassName).toArray(String[]::new);
    }

    public Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = Type.getReturnType((String)this.desc);
        }
        return this.returnType;
    }

    public Class realClass() {
        if (this.realClass == null) {
            this.realClass = ClassLoad.loadClass(this.realClassDesc);
        }
        return this.realClass;
    }

    public MethodId setTarget(Class declaredClass, Object target) {
        this.realClass = declaredClass;
        this.targetHashCode = target == null ? 0 : System.identityHashCode(target);
        return this;
    }

    public Map<Integer, ParaNameType> getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = new LinkedHashMap<Integer, ParaNameType>();
        Type[] types = Type.getArgumentTypes((String)this.descNoInvocation);
        for (int index = 0; index < types.length; ++index) {
            this.parameters.put(index, new ParaNameType(String.format("arg%d", index), types[index].getDescriptor()));
        }
        return this.parameters;
    }

    public void addParaNameType(int index, String name, String type) {
        if (this.parameters == null) {
            this.parameters = new HashMap<Integer, ParaNameType>();
        }
        this.parameters.put(index, new ParaNameType(name, type));
    }

    public String toString() {
        return this.realClassDesc + "#" + this.methodDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodId)) {
            return false;
        }
        MethodId other = (MethodId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$methodDesc = this.methodDesc;
        String other$methodDesc = other.methodDesc;
        return !(this$methodDesc == null ? other$methodDesc != null : !this$methodDesc.equals(other$methodDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodDesc = this.methodDesc;
        result = result * 59 + ($methodDesc == null ? 43 : $methodDesc.hashCode());
        return result;
    }

    public boolean isMockMethod() {
        return this.isMockMethod;
    }

    public MethodId setMockMethod(boolean isMockMethod) {
        this.isMockMethod = isMockMethod;
        return this;
    }

    public static class ParaNameType {
        public final String name;
        public final String type;

        public ParaNameType(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return "MethodId.ParaNameType(name=" + this.name + ", type=" + this.type + ")";
        }
    }
}

