/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.meta.FakeMethods;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.startup.Startup;

public class FakeStates
extends ConcurrentHashMap<Long, FakeMethods> {
    private static final FakeStates initFakes = new FakeStates(32);
    private static final FakeStates testFakes = new FakeStates(32);

    public FakeStates(int initialCapacity) {
        super(initialCapacity);
    }

    private FakeMethod lastMethod(MethodId declared) {
        long fakeId = 0L;
        FakeMethod last = null;
        for (Map.Entry entry : this.entrySet()) {
            FakeMethods fakeMethods = (FakeMethods)entry.getValue();
            FakeMethod matched = fakeMethods.findMethod(declared);
            if (matched == null) continue;
            Set<Integer> fakeHashCodes = matched.fake.fakedHashCodes;
            if (fakeHashCodes.isEmpty()) {
                long curr = (Long)entry.getKey();
                if (curr <= fakeId) continue;
                last = matched;
                fakeId = (Long)entry.getKey();
                continue;
            }
            if (!fakeHashCodes.contains(declared.targetHashCode)) continue;
            return matched;
        }
        return last;
    }

    public static void register(FakeMethods fakeMethods) {
        if (Startup.initializing) {
            initFakes.put(fakeMethods.fakeSeqNo, fakeMethods);
        } else {
            testFakes.put(fakeMethods.fakeSeqNo, fakeMethods);
        }
    }

    public static long getMaxFakeId() {
        long max = 0L;
        for (Long curr : testFakes.keySet()) {
            if (max >= curr) continue;
            max = curr;
        }
        return max;
    }

    public static synchronized Long rollback(Long previousMaxFakeId) {
        if (previousMaxFakeId == null) {
            return null;
        }
        Iterator it = testFakes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            long fakeId = (Long)entry.getKey();
            FakeMethods methods = (FakeMethods)entry.getValue();
            if (fakeId <= previousMaxFakeId && !methods.mockByFluent()) continue;
            methods.clear();
            it.remove();
        }
        return Long.MAX_VALUE;
    }

    public static FakeMethod getLastMethod(MethodId real) {
        FakeMethod fakeMethod = testFakes.lastMethod(real);
        if (fakeMethod == null) {
            return initFakes.lastMethod(real);
        }
        return fakeMethod;
    }
}

