/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import g_asm.org.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.test4j.mock.faking.fluent.FluentMockUp;
import org.test4j.mock.faking.meta.AbstractFake;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.TypeUtility;

public class FakeMethods {
    public final long fakeSeqNo;
    private final List<FakeMethod> methods = new ArrayList<FakeMethod>();

    public FakeMethods(long fakeSeqNo) {
        this.fakeSeqNo = fakeSeqNo;
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public AbstractFake getMockUp() {
        return this.isEmpty() ? null : this.methods.get((int)0).fake;
    }

    public FakeMethod findMethod(MethodId methodId) {
        FakeMethod compatible = null;
        for (FakeMethod method : this.methods) {
            if (!this.isClassMatch(methodId, method.meta)) continue;
            if (Objects.equals(method.meta.methodDesc, methodId.methodDesc)) {
                return method;
            }
            if (!this.isCompatible(method.meta.methodDesc, methodId.methodDesc)) continue;
            compatible = method;
        }
        return compatible;
    }

    private boolean isClassMatch(MethodId real, MethodId fake) {
        if (Objects.equals(real.declaredClassDesc, fake.declaredClassDesc) || fake.declaredClassDesc == null) {
            return TypeUtility.isAssignable(fake.realClass(), real.realClass());
        }
        return false;
    }

    private boolean isCompatible(String fakeDesc, String declaredDesc) {
        Type[] declaredTypes;
        if (!Objects.equals(MethodId.getName(fakeDesc), MethodId.getName(declaredDesc))) {
            return false;
        }
        Type[] fakeTypes = Type.getArgumentTypes((String)MethodId.getDesc(fakeDesc));
        if (fakeTypes.length != (declaredTypes = Type.getArgumentTypes((String)MethodId.getDesc(declaredDesc))).length) {
            return false;
        }
        for (int index = 0; index < fakeTypes.length; ++index) {
            String declareTypeName;
            String fakeTypeName = fakeTypes[index].getClassName();
            if (Objects.equals(fakeTypeName, declareTypeName = declaredTypes[index].getClassName())) continue;
            Class fakeType = ClassLoad.loadClass(fakeTypeName);
            Class declaredType = ClassLoad.loadClass(declareTypeName);
            if (TypeUtility.isAssignable(declaredType, fakeType)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        for (FakeMethod fm : this.methods) {
            if (!(fm.fake instanceof FluentMockUp)) continue;
            ((FluentMockUp)fm.fake).clear();
        }
        this.methods.clear();
    }

    public void add(FakeMethod fakeMethod) {
        this.methods.add(fakeMethod);
    }

    public String toString() {
        return "[" + this.fakeSeqNo + "]:" + this.methods;
    }

    public boolean mockByFluent() {
        return this.isEmpty() || this.getMockUp() instanceof FluentMockUp;
    }
}

