/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.meta;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.test4j.mock.Invocation;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.util.ReflectUtility;

public class FakeInvocation
extends Invocation {
    private final Object target;
    private final FakeMethod fakeMethod;
    private final Executable invokedMember;
    private final Object[] args;
    private final int invokedTimes;
    private boolean proceeding;

    public FakeInvocation(Object target, Object[] args, FakeMethod fakeMethod, Executable invokedMember) {
        this.target = target;
        this.args = args;
        this.fakeMethod = fakeMethod;
        this.invokedTimes = fakeMethod.getTimesInvoked();
        this.invokedMember = invokedMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T proceed(Object ... args) {
        this.fakeMethod.setProceedingInvocation(this);
        this.proceeding = true;
        if (this.invokedMember instanceof Constructor) {
            return (T)"_Enter_Non_Mock_Block_";
        }
        try {
            Object[] actualArgs = args != null && args.length > 0 ? args : this.args;
            Object t = ReflectUtility.invoke(this.target, (Method)this.invokedMember, actualArgs);
            return t;
        }
        finally {
            this.fakeMethod.clearProceedIndicator();
        }
    }

    public boolean isProceedIntoConstructor() {
        if (this.proceeding && this.invokedMember instanceof Constructor) {
            this.fakeMethod.clearProceedIndicator();
            return true;
        }
        return false;
    }

    public static void prepareToProceedNonRecursiveMock(Invocation invocation) {
        ((FakeInvocation)invocation).fakeMethod.setProceedingInvocation4NonRecursive(invocation);
    }

    public <M extends Member> M getInvokedMember() {
        return (M)this.invokedMember;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public int getInvokedTimes() {
        return this.invokedTimes;
    }

    public boolean isProceeding() {
        return this.proceeding;
    }

    public void setProceeding(boolean proceeding) {
        this.proceeding = proceeding;
    }
}

