/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking.fluent;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.test4j.Context;
import org.test4j.mock.Invocation;
import org.test4j.mock.MockUp;
import org.test4j.mock.faking.fluent.FakeFunction;
import org.test4j.mock.faking.fluent.FakeResult;
import org.test4j.mock.faking.fluent.MethodBehaviors;
import org.test4j.mock.faking.fluent.MockBehavior;
import org.test4j.mock.faking.fluent.MockMethod;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.meta.FakeMethods;
import org.test4j.mock.faking.meta.FakeStates;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.util.ObjectIdentify;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.mock.startup.Startup;

public class FluentMockUp<T>
extends MockUp<T> {
    private final Map<String, MockMethod> methods = new HashMap<String, MockMethod>();
    protected final MethodBehaviors behaviors;
    private boolean registered = false;
    private final FakeMethods fakeMethods = new FakeMethods(this.fakedSeqNo);
    private final Map<String, Consumer<Invocation>> parasAsserts = new HashMap<String, Consumer<Invocation>>();
    private final Map<String, BiConsumer<Invocation, Object>> resultAsserts = new HashMap<String, BiConsumer<Invocation, Object>>();

    public FluentMockUp() {
        this.behaviors = new MethodBehaviors(this.declaredToFake);
    }

    public FluentMockUp(Class declaredToFake) {
        super(declaredToFake, new Object[0]);
        this.behaviors = new MethodBehaviors(this.declaredToFake);
    }

    public FluentMockUp(String fullClassName, Object[] objects) {
        super(fullClassName, (Object[])ObjectIdentify.identities(objects));
        this.behaviors = new MethodBehaviors(this.declaredToFake);
    }

    public FluentMockUp(Class declaredClass, MethodBehaviors behaviors, Set<Integer> fakedHashCodes) {
        super(declaredClass, fakedHashCodes);
        assert (behaviors != null) : "behaviors can't be null.";
        this.behaviors = behaviors;
    }

    public void put(String methodName, MockMethod mockMethod) {
        this.methods.put(methodName, mockMethod);
    }

    @Override
    protected final void initFakeMethods() {
    }

    protected void init() {
    }

    public void apply() {
        if (Context.currTestMethod() == null) {
            throw new IllegalStateException("Behaviors of FluentMockUp can only be applied in test methods.");
        }
        if (Startup.initializing) {
            throw new IllegalStateException("Behaviors of FluentMockUp can't be applied in global mock, please use new MockUp() style.");
        }
        if (!this.registered) {
            this.init();
            FakeStates.register(this.fakeMethods);
            this.registered = true;
        }
    }

    public void clear() {
        for (String method : this.behaviors.keySet()) {
            MockMethod mockMethod = this.methods.get(method);
            if (mockMethod == null) continue;
            mockMethod.resetIndex();
        }
        this.behaviors.clear();
        this.registered = false;
    }

    public void mockMethod(String realClass, String name, String desc, int index, FakeFunction fake) {
        this.addMockBehavior(realClass, name, desc, index, fake);
    }

    public void mockReturn(String realClass, String name, String desc, int index, Object result) {
        this.addMockBehavior(realClass, name, desc, index, FakeResult.value(result));
    }

    public void mockThrows(String realClass, String name, String desc, int index, Throwable e) {
        this.addMockBehavior(realClass, name, desc, index, FakeResult.eject(e));
    }

    private void addMockBehavior(String realClass, String name, String desc, int index, MockBehavior behavior) {
        MethodId meta = this.behaviors.addMockBehavior(realClass, name, desc, index, behavior);
        this.fakeMethods.add(new FakeMethod(this, meta));
    }

    public Object invoke(Invocation invocation, String methodDesc, Object[] args) {
        int index = invocation.getInvokedTimes();
        this.assertBefore(methodDesc, invocation);
        MockBehavior behavior = this.getBehavior(index, methodDesc);
        if (behavior == null) {
            Object result = invocation.proceed(args);
            return this.assertAfter(methodDesc, invocation, result);
        }
        if (behavior instanceof FakeFunction) {
            return ((FakeFunction)behavior).doFake(invocation);
        }
        FakeResult result = (FakeResult)behavior;
        if (result.isThrowable()) {
            return ReflectUtility.doThrow((Throwable)result.getResult());
        }
        return this.assertAfter(methodDesc, invocation, result.getResult());
    }

    void addAssertMethodParas(String methodDesc, Consumer<Invocation> asserts) {
        this.parasAsserts.put(methodDesc, asserts);
    }

    void addAssertMethodResult(String methodDesc, BiConsumer<Invocation, Object> asserts) {
        this.resultAsserts.put(methodDesc, asserts);
    }

    private void assertBefore(String methodDesc, Invocation invocation) {
        Consumer<Invocation> asserts = this.parasAsserts.get(methodDesc);
        if (asserts != null) {
            asserts.accept(invocation);
        }
    }

    private Object assertAfter(String methodDesc, Invocation invocation, Object result) {
        BiConsumer<Invocation, Object> asserts = this.resultAsserts.get(methodDesc);
        if (asserts != null) {
            asserts.accept(invocation, result);
        }
        return result;
    }

    private MockBehavior getBehavior(int index, String methodDesc) {
        Map methods = (Map)this.behaviors.get(methodDesc);
        if (methods == null || methods.isEmpty()) {
            return null;
        }
        MockBehavior behavior = (MockBehavior)methods.get(index);
        if (behavior == null) {
            behavior = (MockBehavior)methods.get(0);
        }
        return behavior;
    }

    public String getFakeClass(String realClass) {
        if (realClass == null) {
            return this.declaredToFake.getName().replace('.', '/');
        }
        return realClass;
    }
}

