/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock.faking;

import g_asm.org.objectweb.asm.Type;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Objects;
import org.test4j.mock.Invocation;
import org.test4j.mock.faking.fluent.FluentMockUp;
import org.test4j.mock.faking.meta.FakeInvocation;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.modifier.BridgeTransformer;
import org.test4j.mock.faking.util.ClassLoad;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.mock.faking.util.TypeUtility;

public class FakeInvoker {
    private final Object target;
    private final FakeMethod fakeMethod;
    private final String realClassDesc;
    private final String methodName;
    private final String paramsDesc;
    private final Object[] args;

    public FakeInvoker(Object target, FakeMethod fakeMethod, Class realClass, Method method, Object[] args) {
        this.target = target;
        this.fakeMethod = fakeMethod;
        this.realClassDesc = TypeUtility.classPath(realClass);
        this.methodName = method.getName();
        this.paramsDesc = Type.getMethodDescriptor((Method)method);
        this.args = args;
    }

    public FakeInvoker(Object target, FakeMethod fakeMethod, String realClassDesc, String methodName, String paramsDesc, Object[] args) {
        this.target = target;
        this.fakeMethod = fakeMethod;
        this.realClassDesc = realClassDesc;
        this.methodName = methodName;
        this.paramsDesc = paramsDesc;
        this.args = args;
    }

    public Object callFakeMethod() {
        assert (this.fakeMethod != null);
        if (this.fakeMethod.fake instanceof FluentMockUp) {
            return this.callFluentMockUpInvocation();
        }
        if (this.fakeMethod.meta.hasInvocation) {
            return this.callMockWithInvocation();
        }
        return FakeInvoker.callMockWithoutInvocation(this.fakeMethod, this.args);
    }

    private Object callFluentMockUpInvocation() {
        return ((FluentMockUp)this.fakeMethod.fake).invoke(this.newInvocation(), this.fakeMethod.meta.methodDesc, this.args);
    }

    public static Object callMockWithoutInvocation(FakeMethod fakeMethod, Object[] args) {
        Method method = fakeMethod.findMockMethod();
        return ReflectUtility.invoke(method, () -> method.invoke((Object)fakeMethod.fake, args));
    }

    private Object callMockWithInvocation() {
        if (this.isCallSuperOverrideMethod()) {
            return "_Enter_Non_Mock_Block_";
        }
        Invocation invocation = this.newInvocation();
        Object result = FakeInvoker.callMockWithInvocation(this.fakeMethod, invocation, this.args);
        if (invocation instanceof FakeInvocation && ((FakeInvocation)invocation).isProceedIntoConstructor()) {
            return "_Enter_Non_Mock_Block_";
        }
        return result;
    }

    private boolean isCallSuperOverrideMethod() {
        FakeInvocation invocation = this.fakeMethod.getProceedingInvocation();
        if (this.target == null || invocation == null) {
            return false;
        }
        Executable executable = (Executable)invocation.getInvokedMember();
        if (this.target == invocation.getTarget() && executable instanceof Method) {
            String invokedClassDesc = TypeUtility.classPath(executable.getDeclaringClass());
            return !Objects.equals(invokedClassDesc, this.realClassDesc);
        }
        return false;
    }

    public static Object callMockWithInvocation(FakeMethod fakeMethod, Invocation inv, Object[] args) {
        Object[] args2 = new Object[1 + args.length];
        args2[0] = inv;
        if (args.length > 0) {
            System.arraycopy(args, 0, args2, 1, args.length);
        }
        Method method = fakeMethod.findMockMethod();
        return ReflectUtility.invoke(method, () -> method.invoke((Object)fakeMethod.fake, args2));
    }

    protected Invocation newInvocation() {
        Class fakedClass = ClassLoad.loadClass(this.realClassDesc);
        Executable invokedMember = ReflectUtility.findMethodByDesc(fakedClass, this.methodName, this.paramsDesc);
        return new FakeInvocation(this.target, this.args, this.fakeMethod, invokedMember);
    }

    public static String getHostClassName() {
        return BridgeTransformer.initBridgeField();
    }
}

