/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.mock;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.test4j.mock.faking.meta.AbstractFake;
import org.test4j.mock.faking.meta.ClassMeta;
import org.test4j.mock.faking.meta.FakeMethod;
import org.test4j.mock.faking.meta.FakeMethods;
import org.test4j.mock.faking.meta.FakeStates;
import org.test4j.mock.faking.meta.MethodId;
import org.test4j.mock.faking.util.ObjectIdentify;
import org.test4j.mock.functions.Executor;
import org.test4j.mock.startup.Startup;

public class MockUp<T>
extends AbstractFake {
    public MockUp(Class declaredClass, Object ... objects) {
        super(declaredClass, ObjectIdentify.identities(objects));
        this.initFakeMethods();
    }

    protected MockUp() {
        this(new Object[0]);
    }

    protected MockUp(Object ... objects) {
        super(ObjectIdentify.identities(objects));
        this.initFakeMethods();
    }

    protected MockUp(String fullClassName, Object ... objects) {
        super(fullClassName, ObjectIdentify.identities(objects));
        this.initFakeMethods();
    }

    protected MockUp(Class declaredClass, Set<Integer> fakedHashCodes) {
        super(declaredClass, fakedHashCodes);
        this.initFakeMethods();
    }

    protected void initFakeMethods() {
        FakeMethods fakeMethods = new FakeMethods(this.fakedSeqNo);
        HashSet<String> matched = new HashSet<String>();
        for (Class<?> fakeClass = this.getClass(); MockUp.class.isAssignableFrom(fakeClass) && fakeClass != MockUp.class; fakeClass = fakeClass.getSuperclass()) {
            List<MethodId> methods = new ClassMeta((Class)this.declaredToFake, fakeClass).methods;
            for (MethodId methodId : methods) {
                if (matched.contains(methodId.methodDesc)) continue;
                FakeMethod fakeMethod = new FakeMethod(this, methodId);
                fakeMethods.add(fakeMethod);
                matched.add(methodId.methodDesc);
            }
        }
        FakeStates.register(fakeMethods);
    }

    public static synchronized void global(Executor mocker) {
        Startup.initializing = true;
        try {
            mocker.execute();
        }
        finally {
            Startup.initializing = false;
        }
    }
}

