/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.spring.registrar;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.test4j.annotations.Mocks;
import org.test4j.integration.spring.BeanRegister;
import org.test4j.integration.spring.BeanRegisterProcessor;

public class MocksScanRegistrar
implements ImportBeanDefinitionRegistrar,
InitializingBean {
    private static final String MocksBeanRegisterProcessorName = "mocksBeanRegisterProcessor";
    private static final ThreadLocal<BeanRegister> TL_MockRegister = new ThreadLocal();

    public void registerBeanDefinitions(AnnotationMetadata metadata, @NonNull BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(Mocks.class.getName()));
        assert (attributes != null);
        Map<String, Class> beans = this.getBeans(attributes);
        this.registryBeanRegisterProcessor(registry, beans);
    }

    private Map<String, Class> getBeans(AnnotationAttributes attributes) {
        String beanName;
        HashMap<String, Class> beans = new HashMap<String, Class>();
        for (Class clazz : attributes.getClassArray("beans")) {
            beanName = BeanRegister.camelName(clazz);
            beans.put(beanName, clazz);
        }
        for (Class clazz : attributes.getAnnotationArray("names")) {
            beanName = clazz.getString("name");
            Class beanType = clazz.getClass("type");
            beans.put(beanName, beanType);
        }
        return beans;
    }

    private void registryBeanRegisterProcessor(BeanDefinitionRegistry registry, Map<String, Class> beans) {
        if (TL_MockRegister.get() == null) {
            TL_MockRegister.set(new BeanRegister());
        }
        for (Map.Entry<String, Class> entry : beans.entrySet()) {
            TL_MockRegister.get().stub(entry.getKey(), entry.getValue());
        }
        if (beans.isEmpty() || registry.containsBeanDefinition(MocksBeanRegisterProcessorName)) {
            return;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(BeanRegisterProcessor.class);
        builder.addConstructorArgValue((Object)TL_MockRegister.get());
        builder.setRole(2);
        registry.registerBeanDefinition(MocksBeanRegisterProcessorName, (BeanDefinition)builder.getBeanDefinition());
    }

    public void afterPropertiesSet() {
        TL_MockRegister.set(null);
    }
}

