/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.spring.registrar;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.test4j.integration.spring.BeanRegister;
import org.test4j.integration.spring.SpringContext;
import org.test4j.integration.spring.registrar.MocksAutowiredPostProcessor;

public class BeansScanRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final String BeansAutowiredPostProcessorName = "beansAutowiredPostProcessor";

    public void registerBeanDefinitions(AnnotationMetadata metadata, @NonNull BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(SpringContext.class.getName()));
        assert (attributes != null);
        List<Class<?>> autowiredClasses = Arrays.asList(attributes.getClassArray("autowired"));
        this.registryAutowiredPostProcessor(registry, autowiredClasses);
        this.registryBeans(registry, attributes);
    }

    private void registryAutowiredPostProcessor(BeanDefinitionRegistry registry, List<Class<?>> autowiredClasses) {
        if (autowiredClasses.isEmpty() || registry.containsBeanDefinition(BeansAutowiredPostProcessorName)) {
            return;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(MocksAutowiredPostProcessor.class);
        builder.addConstructorArgValue(autowiredClasses);
        builder.setRole(2);
        registry.registerBeanDefinition(BeansAutowiredPostProcessorName, (BeanDefinition)builder.getBeanDefinition());
    }

    protected void registryBeans(BeanDefinitionRegistry registry, AnnotationAttributes attributes) {
        AnnotationAttributes[] names;
        Class[] beans;
        for (Class beanType : beans = attributes.getClassArray("beans")) {
            String beanName = BeanRegister.camelName(beanType);
            this.registryBean(registry, beanName, beanType);
        }
        for (AnnotationAttributes name : names = attributes.getAnnotationArray("names")) {
            String beanName = name.getString("name");
            Class beanType = name.getClass("type");
            this.registryBean(registry, beanName, beanType);
        }
    }

    private void registryBean(BeanDefinitionRegistry registry, String beanName, Class<?> beanType) {
        GenericBeanDefinition gbd = new GenericBeanDefinition();
        gbd.setBeanClass(beanType);
        registry.registerBeanDefinition(beanName, (BeanDefinition)gbd);
    }
}

