/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.spring.faker;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.test4j.Context;
import org.test4j.annotations.Mock;
import org.test4j.annotations.Mocks;
import org.test4j.integration.spring.SpringContext;
import org.test4j.mock.Invocation;
import org.test4j.mock.MockUp;

public class SpringBeanMocker {
    private final Set<Class> exists = new HashSet<Class>();

    public SpringBeanMocker() {
        new MockUp<DefaultListableBeanFactory>(){

            @Mock
            public void registerBeanDefinition(Invocation it, String beanName, BeanDefinition beanDefinition) {
                Class testedClass = Context.currTestClass();
                DefaultListableBeanFactory factory = (DefaultListableBeanFactory)it.getTarget();
                SpringBeanMocker.this.addTestClassAsBean(factory, testedClass);
                it.proceed(beanName, beanDefinition);
            }
        };
    }

    private void addTestClassAsBean(DefaultListableBeanFactory factory, Class<?> testedClass) {
        if (this.exists.contains(testedClass)) {
            return;
        }
        this.exists.add(testedClass);
        while (testedClass != null && testedClass != Object.class) {
            SpringContext a = testedClass.getDeclaredAnnotation(SpringContext.class);
            if (a != null || testedClass.isAnnotationPresent(Mocks.class)) {
                this.addBeanRegisterDefinition(factory, testedClass);
            }
            testedClass = testedClass.getSuperclass();
        }
    }

    private void addBeanRegisterDefinition(DefaultListableBeanFactory factory, Class testedClass) {
        String beanName = testedClass.getSimpleName();
        if (factory.containsBeanDefinition(beanName)) {
            return;
        }
        if (Modifier.isAbstract(testedClass.getModifiers())) {
            throw new IllegalStateException("The class[" + testedClass.getName() + "] annotated by @SpringContext/@Mocker can't be Abstract!");
        }
        try {
            GenericBeanDefinition gbd = new GenericBeanDefinition();
            gbd.setBeanClass(testedClass);
            factory.registerBeanDefinition(beanName, (BeanDefinition)gbd);
        }
        catch (Exception e) {
            throw new RuntimeException("add BeanRegister[" + testedClass.getName() + "] bean definition error:" + e.getMessage(), e);
        }
    }
}

