/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.spring;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.lang.NonNull;
import org.test4j.integration.spring.BeanRegister;
import org.test4j.integration.spring.faker.StubFactoryBean;

public class BeanRegisterProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final BeanRegister register;

    public BeanRegisterProcessor(BeanRegister register) {
        this.register = register;
    }

    public BeanRegisterProcessor(String registerClass) {
        try {
            this.register = (BeanRegister)Class.forName(registerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("getRegister error:" + e.getMessage(), e);
        }
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) throws BeansException {
        String beanName;
        for (Map.Entry<String, Object> entry : this.register.faker.entrySet()) {
            beanName = entry.getKey();
            if (registry.containsBeanDefinition(beanName)) {
                registry.removeBeanDefinition(beanName);
            }
            BeanDefinition definition = StubFactoryBean.definition(entry.getValue());
            registry.registerBeanDefinition(beanName, definition);
        }
        for (Map.Entry<String, Object> entry : this.register.beans.entrySet()) {
            beanName = entry.getKey();
            if (registry.containsBeanDefinition(beanName)) {
                registry.removeBeanDefinition(beanName);
            }
            GenericBeanDefinition gbd = new GenericBeanDefinition();
            gbd.setBeanClass((Class)entry.getValue());
            registry.registerBeanDefinition(beanName, (BeanDefinition)gbd);
        }
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (Map.Entry<String, Object> entry : this.register.faker.entrySet()) {
            if (beanFactory.containsBean(entry.getKey())) continue;
            beanFactory.registerSingleton(entry.getKey(), entry.getValue());
        }
    }
}

