/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.junit5;

import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.test.context.TestContextManager;
import org.test4j.integration.junit5.JUnit5Extension;
import org.test4j.mock.faking.util.ReflectUtility;
import org.test4j.module.spring.SpringEnv;

public class JUnit5SpringHelper {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{JUnit5Extension.class});

    public static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    public static TestContextManager getTestContextManager(ExtensionContext context) {
        Assertions.assertNotNull((Object)context, (String)"ExtensionContext must not be null");
        Class testClass = context.getRequiredTestClass();
        ExtensionContext.Store store = JUnit5SpringHelper.getStore(context);
        return (TestContextManager)store.getOrComputeIfAbsent((Object)testClass, TestContextManager::new, TestContextManager.class);
    }

    public static void beforeAll(ExtensionContext context) {
        SpringEnv.setSpringEnv(context.getRequiredTestClass());
        try {
            JUnit5SpringHelper.getTestContextManager(context).beforeTestClass();
        }
        catch (Exception e) {
            ReflectUtility.doThrow(e);
        }
    }

    public static void afterAll(ExtensionContext context) throws Exception {
        try {
            if (SpringEnv.isSpringEnv()) {
                JUnit5SpringHelper.getTestContextManager(context).afterTestClass();
            }
        }
        finally {
            JUnit5SpringHelper.getStore(context).remove((Object)context.getRequiredTestClass());
        }
    }

    public static void beforeMethod(Object target) {
        SpringEnv.injectSpringBeans(target);
    }

    public static void beforeEach(ExtensionContext context) throws Exception {
        Object target = context.getTestInstance().orElse(null);
        Method testMethod = context.getRequiredTestMethod();
        if (SpringEnv.isSpringEnv(context.getRequiredTestClass())) {
            assert (target != null);
            JUnit5SpringHelper.getTestContextManager(context).beforeTestMethod(target, testMethod);
        }
    }

    public static void afterEach(ExtensionContext context) throws Exception {
        Object testInstance = context.getRequiredTestInstance();
        Method testMethod = context.getRequiredTestMethod();
        Throwable testException = context.getExecutionException().orElse(null);
        if (SpringEnv.isSpringEnv(context.getRequiredTestClass())) {
            JUnit5SpringHelper.getTestContextManager(context).afterTestMethod(testInstance, testMethod, testException);
        }
    }
}

