/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.junit5;

import java.lang.reflect.Method;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.test4j.Context;
import org.test4j.integration.ListenerFactory;
import org.test4j.integration.junit5.JUnit5SpringHelper;
import org.test4j.mock.startup.JavaAgentHits;
import org.test4j.module.spring.SpringEnv;

public final class JUnit5Extension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
TestInstancePostProcessor {
    public void beforeAll(ExtensionContext context) {
        if (!JUnit5Extension.isRegularTestClass(context)) {
            return;
        }
        Class testClass = context.getTestClass().orElse(null);
        if (SpringEnv.isSpringEnv(testClass)) {
            JUnit5SpringHelper.beforeAll(context);
        }
        ListenerFactory.beforeAll(testClass);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        JUnit5SpringHelper.afterAll(context);
        if (JUnit5Extension.isRegularTestClass(context)) {
            ListenerFactory.afterAll();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        context.getTestInstance().ifPresent(ListenerFactory::beforeMethod);
        context.getTestMethod().ifPresent(Context::currTestMethod);
        JUnit5SpringHelper.beforeEach(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ListenerFactory.afterMethod();
        JUnit5SpringHelper.afterEach(context);
    }

    public void beforeTestExecution(ExtensionContext context) {
        Method testMethod = context.getTestMethod().orElse(null);
        Object testInstance = context.getTestInstance().orElse(null);
        if (testMethod != null && testInstance != null) {
            ListenerFactory.beforeExecute(testInstance, testMethod);
        }
    }

    public void afterTestExecution(ExtensionContext context) {
        Method testMethod = context.getTestMethod().orElse(null);
        Object testInstance = context.getTestInstance().orElse(null);
        Throwable e = context.getExecutionException().orElse(null);
        ListenerFactory.afterExecute(testInstance, testMethod, e);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        SpringEnv.setSpringEnv(context.getRequiredTestClass());
        if (SpringEnv.isSpringEnv(context.getRequiredTestClass())) {
            SpringEnv.doSpringInitial(testInstance, context);
        }
    }

    private static boolean isRegularTestClass(ExtensionContext context) {
        Class testClass = context.getTestClass().orElse(null);
        return testClass != null && !testClass.isAnnotationPresent(Nested.class);
    }

    static {
        JavaAgentHits.message();
    }
}

