/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.junit4.runner;

import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;
import org.test4j.integration.junit4.runner.NormalRunner;
import org.test4j.integration.junit4.runner.SpringRunner;
import org.test4j.module.spring.SpringEnv;

public interface ProxyRunner {
    public List<FrameworkMethod> computeTestMethods();

    public TestClass getTestClass();

    default public void validateMethod(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List<FrameworkMethod> methods = this.getTestClass().getAnnotatedMethods(annotation);
        if (annotation.isAssignableFrom(Test.class)) {
            methods = this.computeTestMethods();
        }
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoidNoArg(isStatic, errors);
        }
    }

    public static Runner getRunner(Class<?> testClass) throws InitializationError {
        if (SpringEnv.isSpringEnv(testClass)) {
            return SpringRunner.create(testClass);
        }
        return new NormalRunner(testClass);
    }
}

