/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.junit4.helper;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.test4j.integration.junit4.DataFrom;
import org.test4j.integration.junit4.helper.FrameworkMethodWithParameters;

public class DataFromHelper {
    public static List<FrameworkMethod> computeParameterizedTestMethods(Class testClazz, Method testMethod, DataFrom dataFrom) {
        String fromMethod = dataFrom.value();
        if ("".equals(fromMethod)) {
            throw new RuntimeException("You should specify the value property of @DataFrom() item.");
        }
        Class<?> dataFromClazz = dataFrom.clazz();
        if (dataFromClazz == DataFrom.class) {
            dataFromClazz = testMethod.getDeclaringClass();
        }
        return DataFromHelper.computeParameterizedFromDataProviderMethod(testClazz, testMethod, fromMethod, dataFromClazz);
    }

    private static List<FrameworkMethod> computeParameterizedFromDataProviderMethod(Class testClazz, Method testMethod, String dataFromMethod, Class dataFromClaz) {
        Object data = DataFromHelper.getDataFromMethod(dataFromMethod, testClazz, dataFromClaz);
        if (data instanceof Iterator) {
            return DataFromHelper.computeParameterFromIterator(testMethod, (Iterator)data);
        }
        if (data instanceof Object[][]) {
            return DataFromHelper.computeParameterFromArray(testMethod, (Object[][])data);
        }
        throw new RuntimeException("The @DataFrom method can only return value of type Iterator<Object[]> or Object[][].");
    }

    private static Object getDataFromMethod(String dataFromMethod, Class testClazz, Class dataFromClazz) {
        try {
            Class clazz = dataFromClazz;
            if (dataFromClazz.isAssignableFrom(testClazz)) {
                clazz = testClazz;
            }
            Method method = clazz.getDeclaredMethod(dataFromMethod, new Class[0]);
            method.setAccessible(true);
            if (Modifier.isStatic(method.getModifiers())) {
                return method.invoke(null, new Object[0]);
            }
            Object target = clazz.newInstance();
            return method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<FrameworkMethod> computeParameterFromIterator(Method method, Iterator iterator) {
        ArrayList<FrameworkMethod> methodWithParameters = new ArrayList<FrameworkMethod>();
        while (iterator.hasNext()) {
            Object caseData = iterator.next();
            if (caseData instanceof Object[]) {
                methodWithParameters.add(new FrameworkMethodWithParameters(method, (Object[])caseData));
                continue;
            }
            methodWithParameters.add(new FrameworkMethodWithParameters(method, new Object[]{caseData}));
        }
        return methodWithParameters;
    }

    private static List<FrameworkMethod> computeParameterFromArray(Method method, Object[][] array) {
        ArrayList<FrameworkMethod> methodWithParameters = new ArrayList<FrameworkMethod>();
        for (Object[] caseData : array) {
            methodWithParameters.add(new FrameworkMethodWithParameters(method, caseData));
        }
        return methodWithParameters;
    }
}

