/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration.junit4.faker;

import java.lang.reflect.Method;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.test4j.Context;
import org.test4j.annotations.Mock;
import org.test4j.integration.ListenerFactory;
import org.test4j.mock.Invocation;
import org.test4j.mock.MockUp;

public final class FakeFrameworkMethod
extends MockUp<FrameworkMethod> {
    @Mock
    public Object invokeExplosively(Invocation inv, Object target, Object ... params) throws Throwable {
        FrameworkMethod method = (FrameworkMethod)inv.getTarget();
        assert (method != null);
        Method testMethod = method.getMethod();
        if (method.getAnnotation(Before.class) != null) {
            ListenerFactory.beforeMethod(target);
            Context.currTestMethod(method.getMethod());
            return inv.proceed();
        }
        if (method.getAnnotation(AfterClass.class) != null) {
            ListenerFactory.afterMethod();
            return inv.proceed();
        }
        if (method.getAnnotation(Test.class) != null) {
            return this.doExecuteTest(inv, target, testMethod);
        }
        return inv.proceed();
    }

    private Object doExecuteTest(Invocation inv, Object target, Method testMethod) {
        Throwable e = null;
        try {
            ListenerFactory.beforeExecute(target, testMethod);
            Object t = inv.proceed();
            return t;
        }
        catch (Throwable e2) {
            e = e2;
            throw e2;
        }
        finally {
            ListenerFactory.afterExecute(target, testMethod, e);
        }
    }
}

