/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.test4j.Context;
import org.test4j.Logger;
import org.test4j.mock.faking.util.StackTrace;
import org.test4j.module.Test4JListener;
import org.test4j.module.inject.proxy.InjectHelper;

public final class ListenerFactory {
    public static final ListenerFactory factory = new ListenerFactory();
    private final List<Test4JListener> listeners = new ArrayList<Test4JListener>();
    private final List<Test4JListener> reverseListeners;
    private final ThreadLocal<Boolean> doneBeforeMethod = new ThreadLocal();
    private final ThreadLocal<Boolean> needAfterMethod = new ThreadLocal();
    private static final ThreadLocal<Test4JListener> testListener = new ThreadLocal();

    public static void setTestListener(Test4JListener listener) {
        testListener.set(listener);
    }

    private ListenerFactory() {
        ServiceLoader<Test4JListener> loaders = ServiceLoader.load(Test4JListener.class);
        for (Test4JListener loader : loaders) {
            if (loader.init()) {
                this.listeners.add(loader);
                continue;
            }
            Logger.warn("find Test4JListener:" + loader.name() + ", but not init.", new Throwable[0]);
        }
        this.listeners.sort(Comparator.comparing(Test4JListener::order));
        this.reverseListeners = new ArrayList<Test4JListener>(this.listeners);
        Collections.reverse(this.reverseListeners);
    }

    public static void beforeAll(Class testClass) {
        if (testClass == null || factory.isAssignableFromLast(testClass)) {
            return;
        }
        ListenerFactory.afterAll();
        Class aClass = testClass.isSynthetic() ? testClass.getSuperclass() : testClass;
        Context.currTestClass(aClass);
        ListenerFactory.factory.listeners.forEach(item -> item.beforeAll(aClass));
        if (testListener.get() != null) {
            testListener.get().beforeAll(aClass);
        }
    }

    public static void beforeMethod(Object target) {
        ListenerFactory.afterMethod();
        if (ListenerFactory.factory.doneBeforeMethod.get() == null) {
            ListenerFactory.beforeAll(target.getClass());
            Context.currTestObject(target);
            InjectHelper.injectIntoTestedObject(target);
            ListenerFactory.factory.listeners.forEach(item -> item.beforeMethod(target));
            if (testListener.get() != null) {
                testListener.get().beforeMethod(target);
            }
        }
        ListenerFactory.factory.doneBeforeMethod.set(true);
    }

    public static void beforeExecute(Object target, Method method) {
        ListenerFactory.beforeMethod(target);
        ListenerFactory.prepareNextTest();
        Context.currTestMethod(method);
        ListenerFactory.factory.listeners.forEach(item -> item.beforeExecute(target, method));
        if (testListener.get() != null) {
            testListener.get().beforeExecute(target, method);
        }
    }

    public static void afterExecute(Object target, Method method, Throwable e) {
        ListenerFactory.factory.reverseListeners.forEach(item -> item.afterExecute(target, method, e));
        StackTrace.filterStackTrace(e);
        if (testListener.get() != null) {
            testListener.get().afterExecute(target, method, e);
        }
        ListenerFactory.prepareNextTest();
    }

    private static void prepareNextTest() {
        ListenerFactory.factory.doneBeforeMethod.set(null);
        ListenerFactory.factory.needAfterMethod.set(true);
    }

    public static void afterMethod() {
        if (ListenerFactory.factory.needAfterMethod.get() != null) {
            ListenerFactory.factory.reverseListeners.forEach(Test4JListener::afterMethod);
            if (testListener.get() != null) {
                testListener.get().afterMethod();
            }
        }
        ListenerFactory.factory.needAfterMethod.set(null);
        Context.currTestMethod(null);
    }

    public static void afterAll() {
        ListenerFactory.afterMethod();
        if (Context.currTestClass() != null) {
            ListenerFactory.factory.reverseListeners.forEach(Test4JListener::afterAll);
            if (testListener.get() != null) {
                testListener.get().afterAll();
            }
        }
        Context.currTestClass(null);
        Context.currTestObject(null);
    }

    private boolean isAssignableFromLast(Class aClass) {
        Class testClass;
        Class currClass = Context.currTestClass();
        Class clazz = testClass = aClass.isSynthetic() ? aClass.getSuperclass() : aClass;
        if (currClass == null) {
            return false;
        }
        return currClass == testClass || currClass.isAssignableFrom(testClass);
    }
}

