/*
 * Decompiled with CFR 0.152.
 */
package org.test4j;

public class Logger {
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static int level = 0;

    private static void mark(int level, String marker) {
        switch (level) {
            case 3: {
                System.err.println(marker);
                break;
            }
            default: {
                System.out.println(marker);
            }
        }
    }

    public static void debug(Object info, Throwable ... throwables) {
        if (level <= 0) {
            Logger.mark(0, "DEBUG: " + info);
            Logger.printExceptions(throwables);
        }
    }

    public static void warn(Object warn, Throwable ... throwables) {
        if (level <= 2) {
            Logger.mark(2, "WARNING: " + warn);
            Logger.printExceptions(throwables);
        }
    }

    public static void info(Object info, Throwable ... throwables) {
        if (level <= 1) {
            Logger.mark(1, "INFO: " + info);
            Logger.printExceptions(throwables);
        }
    }

    public static void error(Object err, Throwable ... throwables) {
        Logger.mark(3, "ERROR: " + err);
        Logger.printExceptions(throwables);
    }

    private static void printExceptions(Throwable[] throwables) {
        if (throwables == null || throwables.length == 0) {
            return;
        }
        for (Throwable e : throwables) {
            e.printStackTrace();
        }
    }
}

