/*
 * Decompiled with CFR 0.152.
 */
package org.test4j;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.test4j.mock.functions.Executor;

public final class Context {
    private static final AtomicInteger noMockingCount = new AtomicInteger(0);
    private static final ThreadLocal<Class> currTestClass = new InheritableThreadLocal<Class>();
    private static final ThreadLocal<Object> currTestObject = new InheritableThreadLocal<Object>();
    private static final ThreadLocal<Method> currTestMethod = new InheritableThreadLocal<Method>();

    private Context() {
    }

    public static boolean isInsideNoMockingZone() {
        return noMockingCount.get() > 0;
    }

    public static <T> T enterNoMocking(Supplier supplier) {
        try {
            noMockingCount.incrementAndGet();
            Object t = supplier.get();
            return t;
        }
        finally {
            noMockingCount.decrementAndGet();
        }
    }

    public static void enterNoMocking(Executor executor) {
        try {
            noMockingCount.incrementAndGet();
            executor.execute();
        }
        finally {
            noMockingCount.decrementAndGet();
        }
    }

    public static void clearNoMockingZone() {
        noMockingCount.set(0);
    }

    public static Class currTestClass() {
        return currTestClass.get();
    }

    public static void currTestClass(Class testClass) {
        currTestClass.set(testClass);
    }

    public static Object currTestObject() {
        return currTestObject.get();
    }

    public static void currTestObject(Object testObject) {
        currTestObject.set(testObject);
    }

    public static void currTestMethod(Method method) {
        currTestMethod.set(method);
    }

    public static Method currTestMethod() {
        return currTestMethod.get();
    }
}

