/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.script.script;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.List;
import org.test4j.module.database.script.EntityScriptParser;
import org.test4j.tools.commons.StringHelper;

public class H2Script
extends EntityScriptParser {
    public H2Script(EntityScriptParser.DbTypeConvert typeConvert, Class klass) {
        super(typeConvert, klass);
    }

    @Override
    public String script() {
        String tableName = this.getTableName();
        List<EntityScriptParser.ColumnDefine> columns = this.findColumns();
        StringBuilder buff = new StringBuilder().append(String.format("DROP TABLE IF EXISTS %s;\n", tableName)).append(String.format("CREATE TABLE %s (\n\t", tableName)).append(this.parseColumn(columns));
        String key = this.findPrimaryFieldNames(columns);
        if (key != null && !"".equals(key.trim())) {
            buff.append(",\n\t").append(String.format("PRIMARY KEY (%s)", key));
        }
        return buff.append(");\n").toString();
    }

    @Override
    protected String parseColumn(EntityScriptParser.ColumnDefine column) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.dbType().wrap(column.name)).append(" ").append(this.convertColumnType(column.type)).append(" ");
        if (column.notNull || column.primary) {
            buff.append("NOT NULL ");
        } else if (StringHelper.isBlank((String)column.defaultValue)) {
            buff.append("default NULL ");
        }
        if (!StringHelper.isBlank((String)column.defaultValue)) {
            buff.append("default ").append(super.getDefaultValue(column)).append(" ");
        }
        if (column.autoIncrease) {
            buff.append("AUTO_INCREMENT ");
        }
        return buff.toString().trim();
    }

    @Override
    public DbType dbType() {
        return DbType.H2;
    }
}

