/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.script.script;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.List;
import org.test4j.module.database.script.EntityScriptParser;
import org.test4j.tools.commons.StringHelper;

public class DerbyScript
extends EntityScriptParser {
    public DerbyScript(EntityScriptParser.DbTypeConvert typeConvert, Class klass) {
        super(DerbyScript.typeConvert(typeConvert, new DerbyTypeConvert()), klass);
    }

    @Override
    public String script() {
        List<EntityScriptParser.ColumnDefine> columns = this.findColumns();
        String table = this.dbType().wrap(this.getTableName());
        StringBuilder buff = new StringBuilder().append(String.format("CREATE TABLE %s (\n\t", table)).append(this.parseColumn(columns));
        return buff.append(");\n").toString();
    }

    @Override
    protected String parseColumn(EntityScriptParser.ColumnDefine column) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.dbType().wrap(column.name)).append(" ").append(this.convertColumnType(column.type)).append(" ").append(column.notNull ? "NOT NULL " : "");
        if (!StringHelper.isBlank((String)column.defaultValue)) {
            buff.append("default ").append(super.getDefaultValue(column)).append(" ");
        }
        if (column.autoIncrease) {
            buff.append("GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1) ");
        }
        if (column.primary) {
            buff.append("primary key");
        }
        return buff.toString().trim();
    }

    @Override
    public DbType dbType() {
        return DbType.DERBY;
    }

    public static class DerbyTypeConvert
    extends EntityScriptParser.NonDbTypeConvert {
        public DerbyTypeConvert() {
            this.types.put("DATETIME", "DATE");
            this.types.put("TINYINT", "SMALLINT");
            this.types.put("BIT", "SMALLINT");
        }

        @Override
        public String regex(String type) {
            if (this.isEndsUnsigned(type)) {
                return this.trimUnsigned(type);
            }
            return null;
        }
    }
}

