/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.script;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.test4j.module.database.enviroment.normalise.TypeNormaliser;
import org.test4j.module.database.enviroment.normalise.TypeNormaliserFactory;
import org.test4j.module.database.script.StatementStatus;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.reflector.FieldAccessor;

public final class DBHelper {
    public static Map getMapFromResult(ResultSet rs, boolean isCamelName) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        if (rs.next()) {
            return DBHelper.buildMap(rs, isCamelName, rsmd);
        }
        return null;
    }

    public static List<Map> getListMapFromResult(ResultSet rs, boolean isCamelName) throws Exception {
        ArrayList<Map> list = new ArrayList<Map>();
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            Map map = DBHelper.buildMap(rs, isCamelName, rsmd);
            list.add(map);
        }
        return list;
    }

    public static <T> T getPoJoFromResult(ResultSet rs, Class<T> clazz) throws Exception {
        if (rs.next()) {
            ResultSetMetaData rsmd = rs.getMetaData();
            return DBHelper.buildPoJo(rs, clazz, rsmd);
        }
        return null;
    }

    private static <T> T buildPoJo(ResultSet rs, Class<T> clazz, ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        Object pojo = count < 2 ? null : ClazzHelper.newInstance(clazz);
        Object firstField = DBHelper.buildObject(rs, true, rsmd, (key, value) -> {
            if (pojo != null) {
                FieldAccessor.field((Class)clazz, (String)key).set(pojo, value);
            }
        });
        return (T)(pojo == null ? firstField : pojo);
    }

    private static Map buildMap(ResultSet rs, boolean isCamelName, ResultSetMetaData rsmd) {
        HashMap map = new HashMap();
        DBHelper.buildObject(rs, isCamelName, rsmd, map::put);
        return map;
    }

    private static Object buildObject(ResultSet rs, boolean isCamelName, ResultSetMetaData rsmd, BiConsumer<String, Object> consumer) {
        try {
            int count = rsmd.getColumnCount();
            Object first = null;
            for (int index = 1; index <= count; ++index) {
                String key = DBHelper.getCamelFieldName(rsmd, index, isCamelName);
                String columnClaz = rsmd.getColumnClassName(index);
                Object o = Timestamp.class.getName().endsWith(columnClaz) ? rs.getTimestamp(index) : (Clob.class.getName().endsWith(columnClaz) ? rs.getClob(index) : rs.getObject(index));
                Object value = DBHelper.normaliseValue(columnClaz, o);
                consumer.accept(key, value);
                if (index != 1) continue;
                first = value;
            }
            return first;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> getListPoJoFromResult(ResultSet rs, Class<T> clazz) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        while (rs.next()) {
            T o = DBHelper.getPoJoFromResult(rs, clazz);
            list.add(o);
        }
        return list;
    }

    private static String getCamelFieldName(ResultSetMetaData rsmd, int index, boolean isCamelName) throws SQLException {
        String columnName = rsmd.getColumnName(index);
        if (isCamelName) {
            columnName = columnName.replaceAll("[^a-zA-Z0-9]", " ");
            return StringHelper.camel((String)columnName.toLowerCase());
        }
        return columnName;
    }

    public static String[] parseSQL(String content) {
        char[] chars = content.toCharArray();
        ArrayList<String> statements = new ArrayList<String>();
        StatementStatus status = StatementStatus.NORMAL;
        StringBuilder buff = new StringBuilder();
        block6: for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            switch (status) {
                case SINGLE_NOTE: {
                    if (ch != '\n' && ch != '\r') continue block6;
                    buff.append(' ');
                    status = StatementStatus.NORMAL;
                    continue block6;
                }
                case MULTI_NOTE: {
                    int next;
                    int n = next = index == chars.length - 1 ? 47 : chars[index + 1];
                    if (ch != '*' || next != 47) continue block6;
                    ++index;
                    status = StatementStatus.NORMAL;
                    continue block6;
                }
                case SINGLE_QUOTATION: {
                    buff.append(ch);
                    if (ch != '\'') continue block6;
                    status = StatementStatus.NORMAL;
                    continue block6;
                }
                case DOUBLE_QUOTATION: {
                    buff.append(ch);
                    if (ch != '\"') continue block6;
                    status = StatementStatus.NORMAL;
                    continue block6;
                }
                default: {
                    int next;
                    int n = next = index == chars.length - 1 ? 59 : chars[index + 1];
                    if (ch == '-' && next == 45) {
                        ++index;
                        status = StatementStatus.SINGLE_NOTE;
                        continue block6;
                    }
                    if (ch == '/' && next == 42) {
                        ++index;
                        status = StatementStatus.MULTI_NOTE;
                        continue block6;
                    }
                    if (ch == '\'') {
                        buff.append(ch);
                        status = StatementStatus.SINGLE_QUOTATION;
                        continue block6;
                    }
                    if (ch == '\"') {
                        buff.append(ch);
                        status = StatementStatus.DOUBLE_QUOTATION;
                        continue block6;
                    }
                    if (ch == ';') {
                        String statement = buff.toString().trim();
                        if (!"".equals(statement)) {
                            statements.add(statement);
                        }
                        buff = new StringBuilder();
                        continue block6;
                    }
                    if (ch == '\n' || ch == '\r') {
                        buff.append(' ');
                        continue block6;
                    }
                    buff.append(ch);
                }
            }
        }
        String statement = buff.toString().trim();
        if (!"".equals(statement)) {
            statements.add(statement);
        }
        String[] stmts = new String[statements.size()];
        statements.toArray(stmts);
        return stmts;
    }

    public static String getWhereCondition(Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder where = new StringBuilder();
        where.append(" where ");
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                where.append(" and ");
            }
            where.append(entry.getKey()).append("=?");
        }
        return where.toString();
    }

    public static Object normaliseValue(String klass, Object currVal) throws Exception {
        if (currVal == null) {
            return null;
        }
        TypeNormaliser tn = TypeNormaliserFactory.getNormaliser(klass);
        return tn == null ? currVal : tn.normalise(currVal);
    }

    public static String buildH2Unique(String table, String ... fields) {
        if (fields == null || fields.length == 0) {
            return "";
        }
        return "ALTER TABLE " + table + "  ADD CONSTRAINT " + DBHelper.indexName(table, fields, true) + StringHelper.join((String)" UNIQUE(", (String)",", (String[])fields, (String)"); ");
    }

    private static String indexName(String table, String[] fields, boolean isUniq) {
        String uniName = (isUniq ? "UNI" : "INX") + StringHelper.join((String)("_" + table + "_"), (String)"_", (String[])fields, (String)"").toUpperCase();
        uniName = uniName.substring(0, Math.min(uniName.length(), 20)) + "_" + uniName.hashCode();
        return uniName.replace('-', '_');
    }

    public static String buildH2Index(String table, String ... fields) {
        if (fields == null || fields.length == 0) {
            return "";
        }
        return "CREATE INDEX " + DBHelper.indexName(table, fields, false) + StringHelper.join((String)(" ON " + table + "("), (String)",", (String[])fields, (String)"); ");
    }
}

