/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.proxy;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.test4j.Logger;
import org.test4j.module.database.config.DbConfig;
import org.test4j.module.database.config.DbConfigKey;
import org.test4j.module.database.proxy.IDataSourceCreator;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.config.ConfigHelper;

public class DataSourceDefaultCreator
implements IDataSourceCreator {
    private static final Set<String> registered = new HashSet<String>();

    @Override
    public DataSource createDataSource(String dataSourceName) {
        String schemaName = DbConfig.instance().dbSchema(dataSourceName);
        String url = DbConfig.instance().dbUrl(dataSourceName);
        DataSourceDefaultCreator.checkDoesTestDB(url, dataSourceName, schemaName);
        DataSourceDefaultCreator.registerDriver(dataSourceName);
        String driver = DbConfig.instance().dbDriver(dataSourceName);
        String username = DbConfig.instance().dbUsername(dataSourceName);
        String password = DbConfig.instance().dbPassword(dataSourceName);
        String schema = DbConfig.instance().dbSchema(dataSourceName);
        Logger.info((Object)("Creating data source. Driver: " + driver + ", url: " + url + ", user: " + username + ", password: <not shown>"), (Throwable[])new Throwable[0]);
        return this.createDataSource(driver, url, username, password, schema);
    }

    @Override
    public DataSource createDataSource(String driver, String url, String username, String password, String schema) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        if (StringHelper.notBlank((String)schema)) {
            dataSource.setDefaultSchema(schema);
        }
        return dataSource;
    }

    private static void checkDoesTestDB(String url, String dataSourceName, String schemaName) {
        if (DbConfig.instance().isAllowing(dataSourceName)) {
            return;
        }
        throw new RuntimeException("only local db or test db will be allowed to connect,url:" + url + ", schemas:" + schemaName);
    }

    private static void registerDriver(String dataSourceName) {
        String driver = DbConfig.instance().dbDriver(dataSourceName);
        try {
            if (registered.contains(driver)) {
                return;
            }
            DriverManager.registerDriver((Driver)Class.forName(driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            registered.add(driver);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot register SQL driver " + driver);
        }
    }

    public static String getDataSourceConfig(String dataSource, String suffix) {
        String propKey = String.format("db.%s.%s", dataSource, suffix.toLowerCase());
        String value = ConfigHelper.getString((String)propKey, (String)"");
        if (StringHelper.notBlank((String)value)) {
            return value;
        }
        DbType type = DbConfig.instance().dbType(dataSource);
        Map<String, String> map = DbConfigKey.DB_DEFAULT.get(type);
        String _default = map == null ? "" : map.get(suffix);
        return _default == null ? "" : _default;
    }
}

