/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.operator;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.test4j.exception.Exceptions;
import org.test4j.functions.EConsumer;
import org.test4j.functions.EFunction;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.module.database.enviroment.DBEnvironmentFactory;
import org.test4j.module.database.enviroment.TableMeta;
import org.test4j.module.database.operator.IInsertOp;
import org.test4j.tools.datagen.IDataMap;

public class InsertOp
implements IInsertOp {
    private String table;
    private final DBEnvironment env;
    private TableMeta tableMeta;

    public InsertOp() {
        this(DBEnvironmentFactory.getDefaultDBEnvironment());
    }

    public InsertOp(DBEnvironment environment) {
        this.env = environment;
    }

    public static void insertNoException(DBEnvironment env, String table, IDataMap data) {
        try {
            InsertOp op = new InsertOp(env);
            op.insert(table, data);
        }
        catch (Exception e) {
            throw Exceptions.getUndeclaredThrowableExceptionCaused((Throwable)e);
        }
    }

    @Override
    public void insert(String table, IDataMap data) {
        this.table = table;
        this.tableMeta = this.env.getTableMetaData(table);
        this.tableMeta.fillData(data, this.env);
        List datas = data.rows();
        for (Map map : datas) {
            this.env.execute((EFunction<Connection, PreparedStatement>)(EFunction & Serializable)connection -> {
                PreparedStatement st = connection.prepareStatement(this.getInsertCommandText(map));
                return this.setParametersByMap(st, map);
            }, (EConsumer<PreparedStatement>)((EConsumer & Serializable)PreparedStatement::execute));
        }
    }

    private PreparedStatement setParametersByMap(PreparedStatement statement, Map<String, ?> map) {
        int index = 1;
        for (String key : map.keySet()) {
            try {
                Object value = this.getValueByColumn(key, map);
                if (value instanceof InputStream) {
                    InputStream is = (InputStream)value;
                    statement.setBinaryStream(index, is, is.available());
                } else {
                    Object sqlValue = this.env.convertToSqlValue(value);
                    statement.setObject(index, sqlValue);
                }
                ++index;
            }
            catch (Throwable e) {
                throw new RuntimeException("set column[" + key + "] value error:" + e.getMessage(), e);
            }
        }
        return statement;
    }

    private Object getValueByColumn(String column, Map<String, ?> map) {
        Object value = map.get(column);
        if (!(value instanceof String)) {
            return value;
        }
        String javaType = this.tableMeta.getColumnType(column);
        value = String.class.getName().equals(javaType) ? this.tableMeta.truncateString(column, (String)value) : this.env.toObjectValue((String)value, javaType);
        return value;
    }

    private String getInsertCommandText(Map<String, ?> map) {
        StringBuilder text = new StringBuilder();
        StringBuilder values = new StringBuilder();
        text.append("insert into ").append(this.env.wrapper(this.table)).append("(");
        boolean isFirst = true;
        for (String key : map.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                text.append(",");
                values.append(",");
            }
            text.append(this.env.wrapper(key));
            values.append("?");
        }
        text.append(") values(").append((CharSequence)values).append(")");
        return text.toString();
    }
}

