/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.enviroment;

import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.tools.datagen.IDataMap;

public class TableMeta {
    String tableName;
    Map<String, ColumnMeta> columns;
    ColumnMeta pkMeta;

    public TableMeta(String table, ResultSetMetaData meta) throws Exception {
        this.tableName = table;
        this.columns = new HashMap<String, ColumnMeta>();
        int count = meta.getColumnCount();
        for (int index = 1; index <= count; ++index) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.columnName = meta.getColumnName(index);
            columnMeta.size = meta.getColumnDisplaySize(index);
            columnMeta.typeName = meta.getColumnTypeName(index);
            columnMeta.isNullable = meta.isNullable(index) == 1;
            columnMeta.javaType = meta.getColumnClassName(index);
            columnMeta.autoIncrement = meta.isAutoIncrement(index);
            if (columnMeta.autoIncrement) {
                this.pkMeta = columnMeta;
            }
            this.columns.put(columnMeta.columnName, columnMeta);
        }
    }

    public String getPkColumn() {
        if (this.pkMeta != null) {
            return this.pkMeta.columnName;
        }
        return null;
    }

    public Map<String, ColumnMeta> getColumns() {
        return this.columns;
    }

    public String getColumnType(String column) {
        ColumnMeta meta = this.getColumns().get(column);
        if (meta == null) {
            throw new RuntimeException("can't find column[" + column + "] field in table[" + this.tableName + "].");
        }
        return meta.javaType;
    }

    public int getColumnSize(String column) {
        ColumnMeta meta = this.getColumns().get(column);
        if (meta == null) {
            throw new RuntimeException("can't find column[" + column + "] field in table[" + this.tableName + "].");
        }
        return meta.size;
    }

    public String truncateString(String column, String input) {
        if (input == null) {
            return null;
        }
        int size = this.getColumnSize(column);
        if (size > input.length()) {
            return input;
        }
        return input.substring(0, size);
    }

    public void fillData(IDataMap data, DBEnvironment environment) {
        Set keys = data.keySet().stream().map(String::toUpperCase).collect(Collectors.toSet());
        for (String key : this.columns.keySet()) {
            if (keys.contains(key.toUpperCase())) continue;
            ColumnMeta column = this.columns.get(key);
            if (column.autoIncrement || column.isNullable) continue;
            Object value = column.getDefaultValue(environment);
            data.kv(key, value, new Object[0]);
        }
    }

    public static class ColumnMeta {
        String columnName;
        int size;
        String typeName;
        boolean isNullable;
        String javaType;
        boolean autoIncrement;

        public String toString() {
            return "[columnName=" + this.columnName + ", size=" + this.size + ", typeName=" + this.typeName + ", isNullable=" + this.isNullable + "]";
        }

        public Object getDefaultValue(DBEnvironment dbEnvironment) {
            if (this.isNullable()) {
                return null;
            }
            if ("java.lang.String".equals(this.javaType)) {
                return "test4j".subSequence(0, Math.min(this.size, 6));
            }
            return dbEnvironment.getDefaultValue(this.javaType);
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }
    }
}

