/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.enviroment;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.test4j.Logger;
import org.test4j.exception.Exceptions;
import org.test4j.functions.EConsumer;
import org.test4j.functions.EFunction;
import org.test4j.module.database.config.DbConfig;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.module.database.enviroment.TableMeta;
import org.test4j.module.database.enviroment.typesmap.AbstractTypeMap;
import org.test4j.module.database.proxy.DataSourceCreator;

public abstract class BaseEnvironment
implements DBEnvironment {
    private final Map<String, TableMeta> metas = new HashMap<String, TableMeta>();
    private final DataSource dataSource;
    private final DbType dbType;
    protected AbstractTypeMap typeMap;

    protected BaseEnvironment(String dataSourceName) {
        this.dataSource = DataSourceCreator.create(dataSourceName);
        this.dbType = DbConfig.instance().dbType(dataSourceName);
    }

    @Override
    public void commit() {
        this.doIt((EConsumer<Connection>)(EConsumer & Serializable)connection -> {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        });
    }

    @Override
    public void rollback() {
        this.doIt((EConsumer<Connection>)(EConsumer & Serializable)connection -> {
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        });
    }

    @Override
    public void execute(String sql, EConsumer<PreparedStatement> executor) {
        this.doIt((EConsumer<Connection>)(EConsumer & Serializable)connection -> {
            try (PreparedStatement st = connection.prepareStatement(sql);){
                executor.accept((Object)st);
            }
        });
    }

    @Override
    public void execute(EFunction<Connection, PreparedStatement> stFunction, EConsumer<PreparedStatement> executor) {
        this.doIt((EConsumer<Connection>)(EConsumer & Serializable)connection -> {
            try (PreparedStatement st = (PreparedStatement)stFunction.apply(connection);){
                executor.accept((Object)st);
            }
        });
    }

    @Override
    public <R> R query(EFunction<Connection, PreparedStatement> stFunction, EFunction<ResultSet, R> resultFunction) {
        return this.doIt((EFunction & Serializable)connection -> {
            try (PreparedStatement st = (PreparedStatement)stFunction.apply(connection);){
                ResultSet rs = st.executeQuery();
                Object object = resultFunction.apply((Object)rs);
                return object;
            }
        });
    }

    @Override
    public <R> R query(String sql, EFunction<ResultSet, R> rsFunction) {
        return this.doIt((EFunction & Serializable)connection -> {
            try (PreparedStatement st = connection.prepareStatement(sql);){
                ResultSet rs = st.executeQuery();
                Object object = rsFunction.apply((Object)rs);
                return object;
            }
            catch (Throwable e) {
                throw new RuntimeException("sql:" + sql, e);
            }
        });
    }

    @Override
    public TableMeta getTableMetaData(String table) {
        if (this.metas.get(table) != null) {
            return this.metas.get(table);
        }
        return (TableMeta)this.query("select * from " + table + " where 1!=1", (EFunction & Serializable)rs -> {
            TableMeta meta = new TableMeta(table, rs.getMetaData());
            this.metas.put(table, meta);
            return meta;
        });
    }

    @Override
    public Object getDefaultValue(String javaType) {
        return this.typeMap.getDefaultValue(javaType);
    }

    @Override
    public Object toObjectValue(String input, String javaType) {
        try {
            return this.typeMap.toObjectByType(input, javaType);
        }
        catch (Exception e) {
            Logger.info((Object)("convert input[" + input + "] to type[" + javaType + "] error, so return input value.\n" + e.getMessage()), (Throwable[])new Throwable[0]);
            return input;
        }
    }

    @Override
    public Object convertToSqlValue(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        return value;
    }

    private <R> R doIt(EFunction<Connection, R> function) {
        Connection connection = null;
        try {
            connection = DataSourceUtils.doGetConnection((DataSource)this.dataSource);
            Object object = function.apply((Object)connection);
            return (R)object;
        }
        catch (Throwable e) {
            throw Exceptions.getUndeclaredThrowableExceptionCaused((Throwable)e);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    private void doIt(EConsumer<Connection> consumer) {
        Connection connection = null;
        try {
            connection = DataSourceUtils.doGetConnection((DataSource)this.dataSource);
            consumer.accept((Object)connection);
        }
        catch (Throwable e) {
            throw Exceptions.getUndeclaredThrowableExceptionCaused((Throwable)e);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }
}

