/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.datagen;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.module.database.IDatabase;
import org.test4j.tools.datagen.DataMap;
import org.test4j.tools.datagen.IDataMap;

public abstract class TableDataMap<DM extends TableDataMap<DM>>
extends DataMap<DM> {
    protected boolean isTable;
    protected final Supplier<Boolean> supplier = () -> this.isTable;
    protected Supplier<String> table = () -> table;

    public String get() {
        return this.table.get();
    }

    protected TableDataMap(String table, boolean isTable) {
        this.isTable = isTable;
    }

    protected TableDataMap(String table, boolean isTable, int size) {
        super(size);
        this.isTable = isTable;
    }

    public DM setTable(Supplier<String> table) {
        this.table = table;
        return (DM)((Object)this);
    }

    public DM setTable(String table) {
        this.table = () -> table;
        return (DM)((Object)this);
    }

    public DM init() {
        return (DM)((Object)this);
    }

    public DM with(Consumer<DM> init) {
        init.accept((DM)((Object)this));
        return (DM)((Object)this);
    }

    public DM eqTable(EqMode ... modes) {
        IDatabase.db.table(this.table.get()).query().eqDataMap((IDataMap)this, modes);
        return (DM)((Object)this);
    }

    public DM eqQuery(String query, EqMode ... modes) {
        IDatabase.db.table(this.table.get()).queryWhere(query).eqDataMap((IDataMap)this, modes);
        return (DM)((Object)this);
    }

    public DM eqQuery(Map query, EqMode ... modes) {
        IDatabase.db.table(this.table.get()).queryWhere(query).eqDataMap((IDataMap)this, modes);
        return (DM)((Object)this);
    }

    public DM countEq(int size) {
        IDatabase.db.table(this.table.get()).count().isEqualTo((Number)size);
        return (DM)((Object)this);
    }

    public DM clean() {
        IDatabase.db.cleanTable(this.table.get(), new String[0]);
        return (DM)((Object)this);
    }

    public DM insert() {
        IDatabase.db.table(this.table.get()).insert(new IDataMap[]{this});
        return (DM)((Object)this);
    }

    public DM cleanAndInsert() {
        return ((TableDataMap)((Object)this.clean())).insert();
    }
}

