/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.datagen;

import java.util.Map;
import java.util.function.Supplier;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.module.database.IDatabase;
import org.test4j.tools.datagen.DataMap;
import org.test4j.tools.datagen.IDataMap;

public class BaseMix<MX extends BaseMix<MX, DM>, DM extends DataMap<DM>> {
    private Supplier<String> table = () -> table;

    protected BaseMix(String table) {
    }

    public MX setTable(Supplier<String> table) {
        this.table = table;
        return (MX)this;
    }

    public MX setTable(String table) {
        this.table = () -> table;
        return (MX)this;
    }

    protected MX cleanTable() {
        IDatabase.db.table(this.table.get()).clean();
        return (MX)this;
    }

    protected MX readyTable(DM data) {
        IDatabase.db.table(this.table.get()).insert(new IDataMap[]{data});
        return (MX)this;
    }

    protected MX checkTable(DM data, EqMode ... modes) {
        IDatabase.db.table(this.table.get()).query().eqDataMap(data, modes);
        return (MX)this;
    }

    protected MX checkTable(String where, DM data, EqMode ... modes) {
        IDatabase.db.table(this.table.get()).queryWhere(where).eqDataMap(data, modes);
        return (MX)this;
    }

    protected MX checkTable(DM where, DM data, EqMode ... modes) {
        IDatabase.db.table(this.table.get()).queryWhere((Map)where).eqDataMap(data, modes);
        return (MX)this;
    }

    protected MX countTable(int count, DM where) {
        IDatabase.db.table(this.table.get()).queryWhere((Map)where).sizeEq(count);
        return (MX)this;
    }

    protected MX countTable(int count, String where) {
        IDatabase.db.table(this.table.get()).queryWhere(where).sizeEq(count);
        return (MX)this;
    }

    protected MX countTable(int count) {
        IDatabase.db.table(this.table.get()).query().sizeEq(count);
        return (MX)this;
    }
}

