/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.reflector;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.test4j.exception.NoSuchFieldRuntimeException;
import org.test4j.exception.NoSuchMethodRuntimeException;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.commons.PrimitiveHelper;
import org.test4j.tools.reflector.ConstructorArgsGenerator;
import org.test4j.tools.reflector.FieldAccessor;
import org.test4j.tools.reflector.MethodAccessor;

public class Reflector {
    public static final Reflector instance = new Reflector();

    private Reflector() {
    }

    public Field getField(Class cls, String name) {
        while (cls != Object.class) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchFieldRuntimeException("No such field: " + name);
    }

    public List<Field> getAllFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (clazz == null || clazz.equals(Object.class)) {
            return result;
        }
        for (Class type = clazz; type != Object.class && type != null; type = type.getSuperclass()) {
            Field[] declaredFields = type.getDeclaredFields();
            result.addAll(Arrays.asList(declaredFields));
        }
        return result;
    }

    public void setFieldValue(Object target, String fieldName, Object fieldValue) {
        FieldAccessor.field(target, fieldName).set(target, fieldValue);
    }

    public void setFieldValue(Class klass, String fieldName, Object fieldValue) {
        FieldAccessor.field(klass, fieldName).setStatic(fieldValue);
    }

    public <T> T getFieldValue(Object target, String fieldName) {
        return FieldAccessor.field(target, fieldName).get(target);
    }

    public <T> T getFieldValue(Class klass, String fieldName) {
        return FieldAccessor.field(klass, fieldName).getStatic();
    }

    public <T> T getFieldValue(Object target, Field field) {
        return FieldAccessor.field(field).get(target);
    }

    public <T> T newInstance(Class<T> aClass) {
        return ClazzHelper.newInstance(aClass);
    }

    public <T> T newInstance(Class<T> aClass, ConstructorArgsGenerator argGenerator) {
        return ClazzHelper.newInstance(aClass, argGenerator);
    }

    public <T> T newInstance(String json) {
        Object o = IKit.json.toObject(json);
        return o;
    }

    public <T> T newInstance(String json, Class<T> clazz) {
        Object o = IKit.json.toObject(json, clazz);
        return o;
    }

    public Method getMethod(Class cls, String name, Class ... parametersType) {
        while (cls != Object.class) {
            try {
                Method[] methods;
                for (Method method : methods = cls.getDeclaredMethods()) {
                    if (!method.getName().equals(name) || !Reflector.matchParasType(parametersType, method.getParameterTypes())) continue;
                    method.setAccessible(true);
                    return method;
                }
                throw new NoSuchMethodRuntimeException();
            }
            catch (NoSuchMethodRuntimeException e) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchMethodRuntimeException("No such method: " + name + "(" + Arrays.toString(parametersType) + ")");
    }

    public List<Method> getMethod(Class cls, String name, int args) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (cls != Object.class) {
            try {
                Method[] declares;
                for (Method method : declares = cls.getDeclaredMethods()) {
                    if (!method.getName().equals(name) || method.getParameterTypes().length != args) continue;
                    methods.add(method);
                }
                throw new NoSuchMethodRuntimeException();
            }
            catch (NoSuchMethodRuntimeException e) {
                cls = cls.getSuperclass();
            }
        }
        return methods;
    }

    public Set<Method> getSettersAssignableFrom(Class clazz, Type type, boolean isStatic) {
        HashSet<Method> settersAssignableFrom = new HashSet<Method>();
        Set<Method> allMethods = this.getAllMethods(clazz);
        for (Method method : allMethods) {
            if (!this.isSetterMethod(method) || !ClazzHelper.isAssignable(type, method.getGenericParameterTypes()[0]) || isStatic != Modifier.isStatic(method.getModifiers())) continue;
            settersAssignableFrom.add(method);
        }
        return settersAssignableFrom;
    }

    public Set<Method> getAllMethods(Class clazz) {
        Method[] declaredMethods;
        HashSet<Method> result = new HashSet<Method>();
        if (clazz == null || clazz.equals(Object.class)) {
            return result;
        }
        for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
            if (declaredMethod.isSynthetic() || declaredMethod.isBridge()) continue;
            result.add(declaredMethod);
        }
        result.addAll(this.getAllMethods(clazz.getSuperclass()));
        return result;
    }

    public Set<Method> getSettersOfType(Class clazz, Type type) {
        HashSet<Method> settersOfType = new HashSet<Method>();
        Set<Method> allMethods = this.getAllMethods(clazz);
        for (Method method : allMethods) {
            if (!this.isSetterMethod(method) || !method.getGenericParameterTypes()[0].equals(type)) continue;
            settersOfType.add(method);
        }
        return settersOfType;
    }

    static boolean matchParasType(Class[] expectList, Class[] actualList) {
        if (expectList == null && actualList == null) {
            return true;
        }
        if (expectList == null || actualList == null) {
            return false;
        }
        if (expectList.length != actualList.length) {
            return false;
        }
        for (int index = 0; index < expectList.length; ++index) {
            Class expected = expectList[index];
            Class actual = actualList[index];
            if (expected == null || expected == actual || actual != null && actual.isAssignableFrom(expected) || PrimitiveHelper.isPrimitiveTypeEquals(expected, actual)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualsMethod(Method method) {
        return "equals".equals(method.getName()) && 1 == method.getParameterTypes().length && Object.class.equals(method.getParameterTypes()[0]);
    }

    public boolean isHashCodeMethod(Method method) {
        return "hashCode".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public boolean isCloneMethod(Method method) {
        return "clone".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public boolean isFinalizeMethod(Method method) {
        return "finalize".equals(method.getName()) && 0 == method.getParameterTypes().length;
    }

    public boolean isSetterMethod(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || methodName.length() < 4) {
            return false;
        }
        String fourthLetter = methodName.substring(3, 4);
        return fourthLetter.toUpperCase().equals(fourthLetter);
    }

    public Set<Method> getAllGetterMethod(Class klass) {
        return this.getAllMethods(klass).stream().filter(this::isGetterMethod).collect(Collectors.toSet());
    }

    public boolean isGetterMethod(Method method) {
        Class<?> klass = method.getReturnType();
        if (klass.equals(Void.class)) {
            return false;
        }
        if (method.getParameterCount() != 0) {
            return false;
        }
        if (this.isStaticMethod(method)) {
            return false;
        }
        String name = method.getName();
        return name.startsWith("get") || name.startsWith("is");
    }

    public Class[] getTypes(Object ... args) {
        if (args == null) {
            return new Class[0];
        }
        ArrayList classes = new ArrayList();
        for (Object para : args) {
            classes.add(para == null ? null : para.getClass());
        }
        return classes.toArray(new Class[0]);
    }

    public boolean isStaticMethod(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    public boolean isPublicStaticVoid(Method method) {
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0 && (method.getModifiers() & 8) != 0 && (method.getModifiers() & 1) != 0;
    }

    public <T> T invoke(Object target, String method, Object ... args) {
        return MethodAccessor.invoke(target, method, args);
    }

    public <T> T invoke(Class klass, String method, Object ... args) {
        return MethodAccessor.invoke(klass, method, args);
    }
}

