/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.reflector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.test4j.exception.NoSuchMethodRuntimeException;
import org.test4j.exception.ReflectionException;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.ClazzHelper;

public class MethodAccessor {
    private final Method method;
    private final Class declaringClass;

    private MethodAccessor(Class declaringClass, String methodName, Class ... parametersType) {
        this.declaringClass = declaringClass;
        this.method = IKit.reflector.getMethod(declaringClass, methodName, parametersType);
    }

    private MethodAccessor(Object target, String methodName, Class ... parametersType) {
        Object _target = ClazzHelper.getProxiedObject(target);
        this.declaringClass = _target.getClass();
        this.method = IKit.reflector.getMethod(this.declaringClass, methodName, parametersType);
    }

    private MethodAccessor(Method method) {
        this.method = method;
        this.declaringClass = method.getDeclaringClass();
    }

    public <T> T invoke(Object target, Object ... args) {
        boolean isAccessible = this.method.isAccessible();
        try {
            this.method.setAccessible(true);
            Object _target = ClazzHelper.getProxiedObject(target);
            Object object = this.method.invoke(_target, args);
            return (T)object;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            throw new RuntimeException(te);
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(ie);
        }
        finally {
            this.method.setAccessible(isAccessible);
        }
    }

    public <T> T invokeStatic(Object ... args) {
        if (!Modifier.isStatic(this.method.getModifiers())) {
            String methodDesc = this.method.getName() + "(" + Arrays.toString(this.method.getParameterTypes()) + ")";
            throw new NoSuchMethodRuntimeException("No such static method: " + methodDesc + " in class[" + this.declaringClass + "]");
        }
        return this.invoke(null, args);
    }

    public static MethodAccessor method(Class declaringClass, String methodName, Class ... parametersType) {
        return new MethodAccessor(declaringClass, methodName, parametersType);
    }

    public static MethodAccessor method(Object target, String methodName, Class ... parametersType) {
        return new MethodAccessor(target, methodName, parametersType);
    }

    public static MethodAccessor method(Method method) {
        return new MethodAccessor(method);
    }

    public static MethodAccessor method(Class targetClazz, String methodName, int args) {
        List<Method> methods = IKit.reflector.getMethod(targetClazz, methodName, args);
        if (methods.size() == 0) {
            throw new ReflectionException("No such method: " + methodName + ",parameter count:" + args);
        }
        if (methods.size() > 1) {
            throw new ReflectionException("More then one method: " + methodName + ",parameter count:" + args);
        }
        Method method = methods.get(0);
        return MethodAccessor.method(method);
    }

    public static MethodAccessor method(Object target, String methodName, int args) {
        Object _target = ClazzHelper.getProxiedObject(target);
        return MethodAccessor.method(_target.getClass(), methodName, args);
    }

    public static <T> T invoke(Object target, String methodName, Object ... args) {
        Object _target = ClazzHelper.getProxiedObject(target);
        Class[] types = IKit.reflector.getTypes(args);
        return MethodAccessor.method(_target, methodName, types).invoke(_target, args);
    }

    public static <T> T invoke(Class klass, String methodName, Object ... args) {
        Class[] types = IKit.reflector.getTypes(args);
        return MethodAccessor.method(klass, methodName, types).invokeStatic(args);
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }
}

