/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.json.interal;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.test4j.tools.config.Config;
import org.test4j.tools.json.impl.FastJsonImpl;
import org.test4j.tools.json.impl.GsonImpl;
import org.test4j.tools.json.interal.JSONInterface;

public class JSONFactory {
    private static JSONInterface instance = null;
    private static final Lock lock = new ReentrantLock();

    public static JSONInterface instance() {
        if (instance == null) {
            lock.lock();
            try {
                if (instance == null) {
                    instance = JSONFactory.createJsonInterface();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return instance;
    }

    private static JSONInterface createJsonInterface() {
        String type = Config.instance().jsonType();
        if ("gson".equalsIgnoreCase(type)) {
            return new GsonImpl();
        }
        return new FastJsonImpl();
    }
}

