/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.datagen;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.test4j.tools.datagen.DataGenerator;

public class IncreaseDataGenerator
extends DataGenerator {
    private final Number from;
    private final Number step;

    public IncreaseDataGenerator(Number from, Number step) {
        this.from = from;
        this.step = step;
    }

    @Override
    public Object generate(int index) {
        if (this.from instanceof Integer) {
            return this.from.intValue() + this.step.intValue() * index;
        }
        if (this.from instanceof Long) {
            return this.from.longValue() + this.step.longValue() * (long)index;
        }
        if (this.from instanceof Short) {
            Integer value = this.from.shortValue() + this.step.shortValue() * index;
            return Short.valueOf(String.valueOf(value));
        }
        if (this.from instanceof BigInteger) {
            long value = this.from.longValue() + this.step.longValue() * (long)index;
            return BigInteger.valueOf(value);
        }
        if (this.from instanceof Double) {
            return this.from.doubleValue() + this.step.doubleValue() * (double)index;
        }
        if (this.from instanceof Float) {
            return Float.valueOf(this.from.floatValue() + this.step.floatValue() * (float)index);
        }
        if (this.from instanceof BigDecimal) {
            double value = this.from.doubleValue() + this.step.doubleValue() * (double)index;
            return BigDecimal.valueOf(value);
        }
        throw new RuntimeException("not support this type number increase, only support type[int, long, short, double, float, BigInteger, BigDecimal].");
    }
}

