/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.datagen;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.test4j.tools.datagen.IDataMap;
import org.test4j.tools.datagen.IncreaseDataGenerator;
import org.test4j.tools.datagen.RandomDataGenerator;
import org.test4j.tools.datagen.RepeatDataGenerator;
import org.test4j.tools.datagen.RowData;

public abstract class DataGenerator {
    IDataMap dataMap;

    public abstract Object generate(int var1);

    public Object value(String field, int row) {
        if (this.dataMap == null) {
            throw new RuntimeException("the data map can't be null.");
        }
        if (!this.dataMap.containsKey(field)) {
            throw new RuntimeException("not existed the key[" + field + "] of data map.");
        }
        return this.dataMap.get(field).row(row);
    }

    public static DataGenerator repeat(Object ... objects) {
        return new RepeatDataGenerator(objects);
    }

    public static DataGenerator random(Class type) {
        return new RandomDataGenerator(type);
    }

    public static DataGenerator increase(Number from, Number step) {
        return new IncreaseDataGenerator(from, step);
    }

    public static DataGenerator increase(final String format, Number from, Number step) {
        return new IncreaseDataGenerator(from, step){

            @Override
            public Object generate(int index) {
                int _index = (Integer)super.generate(index);
                return String.format(format, _index);
            }
        };
    }

    public static DataGenerator increase(Number from, Number step, final Function<Integer, Object> function) {
        return new IncreaseDataGenerator(from, step){

            @Override
            public Object generate(int index) {
                int _index = (Integer)super.generate(index);
                return function.apply(_index);
            }
        };
    }

    public static DataGenerator increase() {
        return DataGenerator.increase(1, 1);
    }

    public static DataGenerator increase(String format) {
        return DataGenerator.increase(format, (Number)1, 1);
    }

    public static DataGenerator increase(Function<Integer, Object> function) {
        return DataGenerator.increase(1, (Number)1, function);
    }

    public static DataGenerator increase(final BiFunction<Integer, RowData, Object> function) {
        return new DataGenerator(){

            @Override
            public Object generate(int index) {
                return function.apply(index, new RowData(this.dataMap, index));
            }
        };
    }

    public void setDataMap(IDataMap dataMap) {
        this.dataMap = dataMap;
    }
}

