/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.database;

import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.database.SqlKeyWord;

public class SQLUtility {
    public static String parseTable(String sql) {
        return SQLUtility.split(sql, SqlKeyWord.Table_Between);
    }

    public static String parseWhere(String sql) {
        return SQLUtility.split(sql, SqlKeyWord.Where_Between);
    }

    public static String[] parseSelect(String sql) {
        String fields = SQLUtility.split(sql, SqlKeyWord.Select_Between);
        return (String[])Arrays.stream(fields.split(",")).map(String::trim).toArray(String[]::new);
    }

    public static String split(String sql, List<SqlKeyWord.ItemBetweenKey> betweenKeys) {
        StringTokenizer tokenizer = new StringTokenizer(sql);
        StringBuilder buff = new StringBuilder();
        boolean hasMatchBegin = false;
        List<String> ends = null;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!hasMatchBegin && (ends = SqlKeyWord.isMatchBegin(betweenKeys, word)) != null) {
                hasMatchBegin = true;
                continue;
            }
            if (SqlKeyWord.isMatchEnd(ends, word)) break;
            if (!hasMatchBegin) continue;
            buff.append(word).append(" ");
        }
        return buff.toString().trim();
    }

    public static String filterSpace(String sql) {
        boolean inSingleQuotation = false;
        boolean inDoubleQuotation = false;
        StringBuilder buff = new StringBuilder();
        char preChar = '\u0000';
        for (char ch : sql.toCharArray()) {
            if (StringHelper.isSpace(ch)) {
                if (inDoubleQuotation) {
                    buff.append(ch);
                } else {
                    buff.append(StringHelper.isSpace(preChar) ? "" : " ");
                }
            } else {
                buff.append(ch);
            }
            if (ch == '\"' && preChar != '\\') {
                boolean bl = inDoubleQuotation = !inDoubleQuotation && !inSingleQuotation;
            }
            if (ch == '\'' && preChar != '\\') {
                inSingleQuotation = !inSingleQuotation && !inDoubleQuotation;
            }
            preChar = ch;
        }
        return buff.toString();
    }
}

