/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.config;

import java.util.Map;
import java.util.Properties;
import org.test4j.Logger;
import org.test4j.tools.commons.PropertiesReader;
import org.test4j.tools.commons.StrSubstitutor;
import org.test4j.tools.config.ConfigHelper;

public class ConfigLoader {
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "test4j-default.properties";
    public static final String TEST4J_CONFIG_FILES = "test4j.config.files";
    private final PropertiesReader propertiesReader = new PropertiesReader();
    private static Properties properties = null;

    public static synchronized Properties loading() {
        if (properties == null) {
            String[] files;
            ConfigLoader loader = new ConfigLoader();
            properties = new Properties();
            for (String file : files = loader.loadDefaultConfiguration(properties)) {
                loader.loadCustomConfiguration(properties, file);
            }
            loader.loadSystemProperties(properties);
            loader.expandPropertyValues(properties);
        }
        return properties;
    }

    private ConfigLoader() {
    }

    private String[] loadDefaultConfiguration(Properties properties) {
        Properties defaultProperties = this.propertiesReader.loadPropertiesFileFromClasspath(DEFAULT_PROPERTIES_FILE_NAME);
        if (defaultProperties == null) {
            throw new RuntimeException("Configuration file: test4j-default.properties not found in classpath.");
        }
        properties.putAll((Map<?, ?>)defaultProperties);
        String files = ConfigHelper.getString(defaultProperties, TEST4J_CONFIG_FILES);
        return files.split("[,;]");
    }

    private void loadCustomConfiguration(Properties properties, String file) {
        Properties fileProperties = this.propertiesReader.loadPropertiesFileFromClasspath(file);
        if (fileProperties == null) {
            Logger.warn((Object)("No configuration file " + file + " found."), (Throwable[])new Throwable[0]);
        } else {
            properties.putAll((Map<?, ?>)fileProperties);
        }
    }

    private void loadSystemProperties(Properties properties) {
        properties.putAll((Map<?, ?>)System.getProperties());
    }

    private void expandPropertyValues(Properties properties) {
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            try {
                String expandedValue = StrSubstitutor.replace(value, properties);
                properties.put(key, expandedValue);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to load configuration. Could not expand property value for key: " + key + ", value " + value, e);
            }
        }
    }
}

