/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.test4j.exception.NoSuchFieldRuntimeException;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.config.ConfigLoader;

public class ConfigHelper {
    private static Object CONFIG_INSTANCE = null;
    private static final Properties properties = ConfigLoader.loading();

    public static Object getConfig() {
        return CONFIG_INSTANCE;
    }

    public static void setConfig(Object config) {
        CONFIG_INSTANCE = config;
    }

    public static String getString(String key) {
        return properties.getProperty(key);
    }

    public static String getString(String key, String defaultValue) {
        String value = properties.getProperty(key);
        if (StringHelper.isBlank(value)) {
            return defaultValue;
        }
        return value.trim();
    }

    public static String getString(Properties properties, String key) {
        String value = ConfigHelper.getString(properties, key, "");
        if (StringHelper.isBlank(value)) {
            throw new NoSuchFieldRuntimeException("No value found for property " + key);
        }
        return value.trim();
    }

    public static String getString(Properties properties, String key, String defaultValue) {
        assert (properties != null);
        String value = properties.getProperty(key);
        if (StringHelper.isBlank(value)) {
            value = properties.getProperty(key);
        }
        if (StringHelper.isBlank(value)) {
            return defaultValue;
        }
        return value.trim();
    }

    public static List<String> getStringList(String propertyName) {
        return ConfigHelper.getStringList(propertyName, false);
    }

    public static List<String> getStringList(String propertyName, boolean required) {
        String values = ConfigHelper.getString(propertyName);
        if (values == null || "".equals(values.trim())) {
            if (required) {
                throw new NoSuchFieldRuntimeException("No value found for property " + propertyName);
            }
            return new ArrayList<String>(0);
        }
        String[] splitValues = values.split(",");
        ArrayList<String> result = new ArrayList<String>(splitValues.length);
        for (String value : splitValues) {
            result.add(value.trim());
        }
        if (required && result.isEmpty()) {
            throw new NoSuchFieldRuntimeException("No value found for property " + propertyName);
        }
        return result;
    }

    public static boolean getBoolean(String key) {
        String prop = properties.getProperty(key);
        return "true".equalsIgnoreCase(prop);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = properties.getProperty(key);
        if (StringHelper.isBlank(value)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value);
    }

    public static int getInteger(String key, int defaultValue) {
        String prop = properties.getProperty(key);
        try {
            return Integer.parseInt(prop);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static boolean hasProperty(String key) {
        String value = ConfigHelper.getString(key);
        return value != null;
    }
}

